/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.q.api;

import java.util.concurrent.TimeUnit;

public interface Q {
    public void exec() throws Exception;

    public void exec(Perform var1) throws Exception;

    public void exec(RunCondition var1, Perform var2) throws Exception;

    public static abstract class ArrayType<T> {
        private T[] value;

        protected ArrayType(T[] value) {
            this.value = value;
        }

        public T[] getValue() {
            return this.value;
        }
    }

    public static abstract class StringType {
        private String value;

        protected StringType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class IntegerType {
        private int value;

        protected IntegerType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static abstract class LongType {
        private long value;

        protected LongType(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static abstract class FloatType {
        private float value;

        public FloatType(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }
    }

    public static class IterationRunCondition
    implements RunCondition {
        protected final long iterations;
        protected long currentIteration = 0L;

        protected IterationRunCondition(long iterations) {
            this.iterations = iterations;
        }

        public static IterationRunCondition times(long numberOfIterations) {
            return new IterationRunCondition(numberOfIterations);
        }

        @Override
        public boolean isExecutable() {
            if (this.currentIteration < this.iterations) {
                ++this.currentIteration;
                return true;
            }
            return false;
        }
    }

    public static class DurationRunCondition
    implements RunCondition {
        protected long finishTime;

        protected DurationRunCondition(long duration, TimeUnit unit) {
            long durationInMillis = unit.toMillis(duration);
            this.finishTime = System.currentTimeMillis() + durationInMillis;
        }

        public static DurationRunCondition during(long duration, TimeUnit timeUnit) {
            return new DurationRunCondition(duration, timeUnit);
        }

        @Override
        public boolean isExecutable() {
            return System.currentTimeMillis() < this.finishTime;
        }
    }

    public static interface RunCondition {
        public boolean isExecutable();
    }

    public static interface Perform {
        public void execute() throws Exception;
    }
}

