/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.q.api;

import java.util.concurrent.TimeUnit;
import org.arquillian.cube.q.api.Q;

public interface ContainerChaos {
    public Action onCubeDockerHost();

    public static final class IntervalType
    extends Q.LongType {
        protected IntervalType(long value) {
            super(value);
        }

        public static IntervalType intervalInSeconds(long interval) {
            return new IntervalType(interval);
        }

        public static IntervalType interval(long interval, TimeUnit timeUnit) {
            return new IntervalType(timeUnit.toSeconds(interval));
        }
    }

    public static final class ContainersType
    extends Q.StringType {
        protected ContainersType(String value) {
            super(value);
        }

        public static ContainersType regularExpression(String expression) {
            return new ContainersType("re2:" + expression);
        }

        public static ContainersType containers(String ... containers) {
            return new ContainersType(ContainersType.joiner(containers));
        }

        private static String joiner(String ... containers) {
            StringBuilder csv = new StringBuilder();
            for (String container : containers) {
                csv.append(container).append(",");
            }
            return csv.substring(0, csv.length() - 1);
        }
    }

    public static enum KillSignal {
        SIGHUP,
        SIGINT,
        SIGKILL,
        SIGTERM,
        SIGSTOP;

    }

    public static interface Action
    extends Q {
        public Action stop(ContainersType var1, IntervalType var2);

        public Action stopRandomly(ContainersType var1, IntervalType var2);

        public Action remove(ContainersType var1, IntervalType var2);

        public Action removeRandomly(ContainersType var1, IntervalType var2);

        public Action kill(ContainersType var1, IntervalType var2, KillSignal var3);

        public Action killRandomly(ContainersType var1, IntervalType var2, KillSignal var3);
    }
}

