/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.q.api;

import java.util.concurrent.TimeUnit;
import org.arquillian.cube.q.api.Distribution;
import org.arquillian.cube.q.api.LogNormalDistribution;
import org.arquillian.cube.q.api.Q;
import org.arquillian.cube.q.api.UniformDistribution;

public interface NetworkChaos {
    public Action on(String var1, int var2);

    public static class DistributedTimeoutType
    extends TimeoutType {
        private Distribution distribution;

        protected DistributedTimeoutType(Distribution distribution, long value) {
            super(value);
            this.distribution = distribution;
            this.setDistributed();
        }

        public static DistributedTimeoutType logNormalLatencyInMillis(long median, double sigma) {
            return new DistributedTimeoutType(new LogNormalDistribution(median, sigma), median);
        }

        public static DistributedTimeoutType logNormalLatency(long median, TimeUnit medianTimeUnit, double sigma) {
            return new DistributedTimeoutType(new LogNormalDistribution(medianTimeUnit.toMillis(median), sigma), medianTimeUnit.toMillis(median));
        }

        public static DistributedTimeoutType uniformLatencyInMillis(long upper, long lower) {
            return new DistributedTimeoutType(new UniformDistribution(upper, lower), lower);
        }

        public static DistributedTimeoutType uniformLatency(int upper, TimeUnit upperTimeUnit, int lower, TimeUnit lowerTimeUnit) {
            return new DistributedTimeoutType(new UniformDistribution(upperTimeUnit.toMillis(upper), lowerTimeUnit.toMillis(lower)), lowerTimeUnit.toMillis(lower));
        }

        @Override
        public long getValue() {
            return this.distribution.calculate();
        }
    }

    public static class TimeoutType
    extends Q.LongType {
        protected TimeoutType(long value) {
            super(value);
        }

        public static TimeoutType timeoutInMillis(long time) {
            return new TimeoutType(time);
        }

        public static TimeoutType timeout(long time, TimeUnit timeUnit) {
            return new TimeoutType(timeUnit.toMillis(time));
        }
    }

    public static class DistributedLatencyType
    extends LatencyType {
        private Distribution distribution;

        protected DistributedLatencyType(Distribution distribution, long value) {
            super(value);
            this.distribution = distribution;
            this.setDistributed();
        }

        public static DistributedLatencyType logNormalLatencyInMillis(long median, double sigma) {
            return new DistributedLatencyType(new LogNormalDistribution(median, sigma), median);
        }

        public static DistributedLatencyType logNormalLatency(long median, TimeUnit medianTimeUnit, double sigma) {
            return new DistributedLatencyType(new LogNormalDistribution(medianTimeUnit.toMillis(median), sigma), medianTimeUnit.toMillis(median));
        }

        public static DistributedLatencyType uniformLatencyInMillis(long upper, long lower) {
            return new DistributedLatencyType(new UniformDistribution(upper, lower), lower);
        }

        public static DistributedLatencyType uniformLatency(int upper, TimeUnit upperTimeUnit, int lower, TimeUnit lowerTimeUnit) {
            return new DistributedLatencyType(new UniformDistribution(upperTimeUnit.toMillis(upper), lowerTimeUnit.toMillis(lower)), lowerTimeUnit.toMillis(lower));
        }

        @Override
        public long getValue() {
            return this.distribution.calculate();
        }
    }

    public static class LatencyType
    extends Q.LongType {
        protected LatencyType(long value) {
            super(value);
        }

        public static LatencyType latencyInMillis(long time) {
            return new LatencyType(time);
        }

        public static LatencyType latency(long time, TimeUnit timeUnit) {
            return new LatencyType(timeUnit.toMillis(time));
        }
    }

    public static class DistributedJitterType
    extends JitterType {
        private Distribution delayDistribution;

        protected DistributedJitterType(Distribution distribution, int jitter) {
            super(jitter);
            this.delayDistribution = distribution;
            this.setDistributed();
        }

        public static DistributedRateType logNormalLatencyInMillis(long median, double sigma) {
            return new DistributedRateType(new LogNormalDistribution(median, sigma), median);
        }

        public static DistributedRateType logNormalLatency(long median, TimeUnit medianTimeUnit, double sigma) {
            return new DistributedRateType(new LogNormalDistribution(medianTimeUnit.toMillis(median), sigma), medianTimeUnit.toMillis(median));
        }

        public static DistributedRateType uniformLatencyInMillis(long upper, long lower) {
            return new DistributedRateType(new UniformDistribution(upper, lower), lower);
        }

        public static DistributedRateType uniformLatency(int upper, TimeUnit upperTimeUnit, int lower, TimeUnit lowerTimeUnit) {
            return new DistributedRateType(new UniformDistribution(upperTimeUnit.toMillis(upper), lowerTimeUnit.toMillis(lower)), lowerTimeUnit.toMillis(lower));
        }

        @Override
        public long getValue() {
            return this.delayDistribution.calculate();
        }
    }

    public static class JitterType
    extends Q.LongType {
        protected JitterType(long value) {
            super(value);
        }

        public static JitterType jitter(long jitter) {
            return new JitterType(jitter);
        }

        public static JitterType noJitter() {
            return new JitterType(0L);
        }
    }

    public static class DistributedRateType
    extends RateType {
        private Distribution delayDistribution;

        protected DistributedRateType(Distribution distribution, long rate) {
            super(rate);
            this.delayDistribution = distribution;
            this.setDistributed();
        }

        public static DistributedRateType logNormalLatencyInMillis(long median, double sigma) {
            return new DistributedRateType(new LogNormalDistribution(median, sigma), median);
        }

        public static DistributedRateType logNormalLatency(long median, TimeUnit medianTimeUnit, double sigma) {
            return new DistributedRateType(new LogNormalDistribution(medianTimeUnit.toMillis(median), sigma), medianTimeUnit.toMillis(median));
        }

        public static DistributedRateType uniformLatencyInMillis(long upper, long lower) {
            return new DistributedRateType(new UniformDistribution(upper, lower), lower);
        }

        public static DistributedRateType uniformLatency(int upper, TimeUnit upperTimeUnit, int lower, TimeUnit lowerTimeUnit) {
            return new DistributedRateType(new UniformDistribution(upperTimeUnit.toMillis(upper), lowerTimeUnit.toMillis(lower)), lowerTimeUnit.toMillis(lower));
        }

        @Override
        public long getValue() {
            return this.delayDistribution.calculate();
        }
    }

    public static class RateType
    extends Q.LongType {
        protected RateType(long value) {
            super(value);
        }

        public static RateType rate(long rate) {
            return new RateType(rate);
        }
    }

    public static class DistributedDelayType
    extends DelayType {
        private Distribution delayDistribution;

        protected DistributedDelayType(Distribution distribution, long delay) {
            super(delay);
            this.delayDistribution = distribution;
            this.setDistributed();
        }

        public static DistributedDelayType logNormalLatencyInMillis(long median, double sigma) {
            return new DistributedDelayType(new LogNormalDistribution(median, sigma), median);
        }

        public static DistributedDelayType logNormalLatency(long median, TimeUnit medianTimeUnit, double sigma) {
            return new DistributedDelayType(new LogNormalDistribution(medianTimeUnit.toMillis(median), sigma), medianTimeUnit.toMillis(median));
        }

        public static DistributedDelayType uniformLatencyInMillis(long upper, long lower) {
            return new DistributedDelayType(new UniformDistribution(upper, lower), lower);
        }

        public static DistributedDelayType uniformLatency(int upper, TimeUnit upperTimeUnit, int lower, TimeUnit lowerTimeUnit) {
            return new DistributedDelayType(new UniformDistribution(upperTimeUnit.toMillis(upper), lowerTimeUnit.toMillis(lower)), lowerTimeUnit.toMillis(lower));
        }

        @Override
        public long getValue() {
            return this.delayDistribution.calculate();
        }
    }

    public static class DelayType
    extends Q.LongType {
        protected DelayType(long value) {
            super(value);
        }

        public static DelayType delayInMillis(long delay) {
            return new DelayType(delay);
        }

        public static DelayType delay(long delay, TimeUnit timeUnit) {
            return new DelayType(timeUnit.toMillis(delay));
        }
    }

    public static final class SliceAverageSizeType
    extends Q.LongType {
        protected SliceAverageSizeType(long value) {
            super(value);
        }

        public static SliceAverageSizeType sliceAverageSize(long average) {
            return new SliceAverageSizeType(average);
        }
    }

    public static final class SliceSizeVariationType
    extends Q.LongType {
        protected SliceSizeVariationType(long value) {
            super(value);
        }

        public static SliceSizeVariationType sliceSizeVariation(long sizeVariation) {
            return new SliceSizeVariationType(sizeVariation);
        }
    }

    public static final class ToxicityType
    extends Q.FloatType {
        protected ToxicityType(float value) {
            super(value);
        }

        public static ToxicityType fullToxic() {
            return new ToxicityType(1.0f);
        }

        public static ToxicityType noToxic() {
            return new ToxicityType(0.0f);
        }

        public static ToxicityType toxicity(float toxicity) {
            return new ToxicityType(toxicity);
        }
    }

    public static enum ToxicDirectionStream {
        DOWNSTREAM,
        UPSTREAM;

    }

    public static interface Action
    extends Q {
        public Action down();

        public Action timeout(TimeoutType var1);

        public Action timeout(TimeoutType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action latency(LatencyType var1);

        public Action latency(LatencyType var1, JitterType var2, ToxicityType var3, ToxicDirectionStream var4);

        public Action bandwidth(RateType var1);

        public Action bandwidth(RateType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action slowClose(DelayType var1);

        public Action slowClose(DelayType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action slice(SliceAverageSizeType var1, DelayType var2);

        public Action slice(SliceAverageSizeType var1, DelayType var2, SliceSizeVariationType var3, ToxicityType var4, ToxicDirectionStream var5);
    }
}

