/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.q.api;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public interface Q {
    public void exec() throws Exception;

    public void exec(Perform var1) throws Exception;

    public void exec(RunCondition var1, Perform var2) throws Exception;

    public static abstract class ArrayType<T>
    extends BaseType<T[]> {
        protected ArrayType(T[] value) {
            super(false, value);
            this.value = value;
        }

        public String toString() {
            return Arrays.toString((Object[])this.value);
        }
    }

    public static abstract class StringType
    extends BaseType<String> {
        protected StringType(String value) {
            super(false, value);
            this.value = value;
        }

        public String toString() {
            return (String)this.value;
        }
    }

    public static abstract class IntegerType
    extends BaseType<Integer> {
        protected IntegerType(int value) {
            super(false, value);
            this.value = value;
        }

        public String toString() {
            return Integer.toString((Integer)this.value);
        }
    }

    public static abstract class LongType
    extends BaseType<Long> {
        protected LongType(long value) {
            super(false, value);
            this.value = value;
        }

        public String toString() {
            return Long.toString((Long)this.value);
        }
    }

    public static abstract class FloatType
    extends BaseType<Float> {
        public FloatType(float value) {
            super(false, Float.valueOf(value));
            this.value = Float.valueOf(value);
        }

        public String toString() {
            return Float.toString(((Float)this.value).floatValue());
        }
    }

    public static abstract class BaseType<T> {
        private boolean distributed = false;
        protected T value;

        protected BaseType(boolean distributed, T value) {
            this.distributed = distributed;
            this.value = value;
        }

        protected void setDistributed() {
            this.distributed = true;
        }

        public boolean isDistributed() {
            return this.distributed;
        }

        public void calculateValue() {
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class IterationRunCondition
    implements RunCondition {
        private final long iterations;
        protected long currentIteration = 0L;

        protected IterationRunCondition(long iterations) {
            this.iterations = iterations;
        }

        public long getIterations() {
            return this.iterations;
        }

        public static IterationRunCondition times(long numberOfIterations) {
            return new IterationRunCondition(numberOfIterations);
        }

        @Override
        public boolean isExecutable() {
            if (this.currentIteration < this.iterations) {
                ++this.currentIteration;
                return true;
            }
            return false;
        }
    }

    public static class DurationRunCondition
    implements RunCondition {
        private long finishTime;

        protected DurationRunCondition(long duration, TimeUnit unit) {
            long durationInMillis = unit.toMillis(duration);
            this.finishTime = System.currentTimeMillis() + durationInMillis;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public static DurationRunCondition during(long duration, TimeUnit timeUnit) {
            return new DurationRunCondition(duration, timeUnit);
        }

        @Override
        public boolean isExecutable() {
            return System.currentTimeMillis() < this.finishTime;
        }
    }

    public static interface RunCondition {
        public boolean isExecutable();
    }

    public static interface Perform {
        public void execute() throws Exception;
    }
}

