/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.droidium.container.configuration.Validate;

public class DroidiumNativeConfiguration {
    private String serverApk = "selendroid-server.apk";
    private Map<String, String> properties = new HashMap<String, String>();

    public File getServerApk() {
        return new File(this.getProperty("serverApk", this.serverApk));
    }

    public void setProperties(Map<String, String> properties) throws IllegalArgumentException {
        Validate.notNull(properties, (String)"Properties to set for Arquillian Droidium native configuration can not be a null object!");
        this.properties = properties;
    }

    public String getProperty(String name, String defaultValue) throws IllegalStateException {
        Validate.notNullOrEmpty((String)name, (String)"unable to get configuration value of null configuration key");
        Validate.notNullOrEmpty((String)defaultValue, (String)("unable to set configuration value of " + name + " to null"));
        String found = this.properties.get(name);
        if (found == null || found.length() == 0) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String property, String value) throws IllegalStateException {
        Validate.notNullOrEmpty((String)property, (String)"unable to set configuration value which key is null");
        Validate.notNullOrEmpty((String)value, (String)"unable to set configuration value which is null");
        this.properties.put(property, value);
    }

    public void validate() throws IllegalArgumentException, IllegalStateException {
        Validate.isReadable((File)this.getServerApk(), (String)("You must provide a valid path to Android Server APK for Arquillian Droidium native plugin. Plese be sure you have read access to the file you entered: " + this.getServerApk()));
    }
}

