/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.container.utils.Monkey;
import org.arquillian.droidium.native_.selendroid.InvalidSelendroidPortException;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;

public class SelendroidServerManager {
    private static final Logger logger = Logger.getLogger(SelendroidServerManager.class.getName());
    private final AndroidDevice device;
    private final ProcessExecutor executor;
    private final AndroidSDK sdk;
    private static final String TOP_CMD = "top -n 1";
    private static final int SOCKET_TIME_OUT_SECONDS = 10;
    private static final int CONNECTION_TIME_OUT_SECONDS = 10;
    private static final int NUM_CONNECTION_RETIRES = 5;

    public SelendroidServerManager(AndroidDevice device, ProcessExecutor executor, AndroidSDK sdk) {
        Validate.notNull((Object)device, (String)"Android device to set can not be a null object!");
        Validate.notNull((Object)executor, (String)"Process executor to set can not be a null object!");
        Validate.notNull((Object)sdk, (String)"Android SDK to set can not be a null object!");
        this.device = device;
        this.executor = executor;
        this.sdk = sdk;
    }

    public void install(SelendroidDeployment deployment) {
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to deploy can not be a null object!");
        Validate.notNull((Object)deployment.getResigned(), (String)"Resigned Selendroid application to deploy can not be a null object!");
        Command selendroidInstallCommand = new Command().add(this.sdk.getAdbPath()).add("-s").add(this.device.getSerialNumber()).add("install").add(deployment.getResigned().getAbsolutePath());
        if (this.device.isPackageInstalled(deployment.getSelendroidPackageName())) {
            this.device.uninstallPackage(deployment.getSelendroidPackageName());
        }
        logger.fine("Selendroid server installation command: " + selendroidInstallCommand.toString());
        try {
            this.executor.execute(selendroidInstallCommand);
        }
        catch (AndroidExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to execute Selendroid installation process.", new Object[0]);
        }
        if (!this.device.isPackageInstalled(deployment.getServerBasePackage())) {
            throw new AndroidExecutionException("Modified Selendroid server was not installed on device.");
        }
    }

    public void instrument(SelendroidDeployment deployment) {
        Validate.notNull((Object)deployment, (String)"Deployment to instument is a null object!");
        Validate.notNull((Object)deployment.getInstrumentationConfiguration(), (String)"Instrumentation configuration of the underlying deployment is a null object!");
        Validate.notNull((Object)deployment.getInstrumentedDeployment(), (String)"Android deployment for Selendroid deployment is a null object!");
        int port = Integer.parseInt(deployment.getInstrumentationConfiguration().getPort());
        this.createPortForwarding(port, port);
        Command startApplicationInstrumentationCommand = new Command().add("am").add("instrument").add("-e").add("main_activity").add("''").add("-e").add("server_port").add(deployment.getInstrumentationConfiguration().getPort()).add(deployment.getServerBasePackage() + "/io.selendroid.ServerInstrumentation");
        logger.fine(startApplicationInstrumentationCommand.toString());
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile((File)DroidiumFileUtils.getTmpDir()), deployment.getInstrumentedDeployment().getApplicationBasePackage(), true);
            this.device.executeShellCommand(startApplicationInstrumentationCommand.getAsString(), (AndroidDeviceOutputReciever)monkey);
            Monkey.wait((AndroidDevice)this.device, (Monkey)monkey, (String)TOP_CMD);
            this.waitUntilSelendroidServerCommunication(port);
        }
        catch (Exception ex) {
            this.removePortForwarding(port, port);
            throw new AndroidExecutionException(ex.getMessage());
        }
    }

    public void disable(SelendroidDeployment deployment) {
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to disable can not be a null object!");
        this.device.executeShellCommand(new Command().addAsString("pm disable " + deployment.getServerBasePackage()).getAsString());
    }

    public void uninstall(SelendroidDeployment deployment) {
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to uninstall can not be a null object!");
        try {
            Command command = new Command();
            command.addAsString("pm uninstall " + deployment.getServerBasePackage());
            this.device.executeShellCommand(command.getAsString());
        }
        catch (AndroidExecutionException ex) {
            throw new AndroidExecutionException("Unable to uninstall Selendroid server.", (Throwable)ex);
        }
        finally {
            int port = Integer.parseInt(deployment.getInstrumentationConfiguration().getPort());
            this.removePortForwarding(port, port);
        }
    }

    private void waitUntilSelendroidServerCommunication(int port) {
        this.validatePort(port);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.socket.timeout", (Object)10000);
        httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
        HttpGet httpGet = new HttpGet(this.getSelendroidStatusURI(port));
        boolean connectionSuccess = false;
        for (int i = 5; i > 0; --i) {
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    connectionSuccess = true;
                    break;
                }
                logger.log(Level.INFO, i + ": Response was not 200 from port " + port + ", response was: " + statusCode);
                continue;
            }
            catch (ClientProtocolException e) {
                logger.log(Level.WARNING, e.getMessage());
                continue;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
        httpClient.getConnectionManager().shutdown();
        if (!connectionSuccess) {
            throw new AndroidExecutionException("Unable to get successful connection from Selendroid http server.");
        }
    }

    private URI getSelendroidStatusURI(int port) {
        try {
            return new URI("http://localhost:" + port + "/wd/hub/status");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private void createPortForwarding(int from, int to) {
        this.validatePort(from);
        this.validatePort(to);
        logger.log(Level.FINE, "Creating port forwarding from {0} to {1}", new Object[]{from, to});
        this.device.createPortForwarding(from, to);
    }

    private void removePortForwarding(int from, int to) {
        this.validatePort(from);
        this.validatePort(to);
        logger.log(Level.FINE, "Removing port forwarding from {0} to {1}", new Object[]{from, to});
        this.device.removePortForwarding(from, to);
    }

    private void validatePort(int port) {
        if (port < 1024 || port > 65535) {
            throw new InvalidSelendroidPortException("You have to specify port between 1024 and 65535, you entered: " + port);
        }
    }
}

