/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.activity;

import java.util.List;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.native_.activity.ActivityWebDriverMapper;
import org.arquillian.droidium.native_.deployment.ActivityDeploymentMapper;
import org.arquillian.droidium.native_.deployment.DeploymentWebDriverMapper;
import org.arquillian.droidium.native_.deployment.ExtensionDroneMapper;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.openqa.selenium.WebDriver;

public class DroidiumNativeActivityManager {
    private static final Logger logger = Logger.getLogger(DroidiumNativeActivityManager.class.getName());
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<DeploymentWebDriverMapper> deploymentWebDriverMapper;
    @Inject
    private Instance<ExtensionDroneMapper> extensionDroneMapper;
    @Inject
    private Instance<ActivityDeploymentMapper> activityDeploymentMapper;
    @Inject
    private Instance<ActivityWebDriverMapper> activityWebDriverMapper;

    public void addAllActitiviesForDrone(@Observes AfterDroneInstantiated event) {
        String extensionQualifier = ((ExtensionDroneMapper)this.extensionDroneMapper.get()).getExtensionQualifierForDroneQualifer(event.getQualifier().getSimpleName().toLowerCase());
        if (extensionQualifier == null) {
            logger.info("No extension qualifier for this WebDriver instance which is supposed to control Android activities was found.");
            return;
        }
        String deploymentName = ((DeploymentWebDriverMapper)this.deploymentWebDriverMapper.get()).getDeploymentName(extensionQualifier);
        if (deploymentName == null) {
            logger.info("No deployment for this WebDriver instance which is supposed to control Android activities was found.");
            return;
        }
        WebDriver instance = (WebDriver)event.getInstance().asInstance(WebDriver.class);
        List<String> activities = ((ActivityDeploymentMapper)this.activityDeploymentMapper.get()).getActivities(deploymentName);
        ((ActivityWebDriverMapper)this.activityWebDriverMapper.get()).put(instance, activities);
    }

    public void removeAllActivitiesForDrone(@Observes BeforeDroneDestroyed event) {
        WebDriver instance = (WebDriver)event.getInstance().asInstance(WebDriver.class);
        ((ActivityWebDriverMapper)this.activityWebDriverMapper.get()).removeActivities(instance);
    }
}

