/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.arquillian.core.spi.Validate;

public class ActivityDeploymentMapper {
    private static final Logger logger = Logger.getLogger(ActivityDeploymentMapper.class.getName());
    private static final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public void put(String activity, String deployment) {
        Validate.notNullOrEmpty((String)activity, (String)"Activity name can not be an empty string or a null object! Use FQDN please.");
        Validate.notNullOrEmpty((String)deployment, (String)("Deployment name of underlying package where activity is located can not be a null object nor an empty string! Please specify deployment name of @Deployment where the activity is located. You tried to put activity '" + activity + "'."));
        if (map.containsKey(activity)) {
            logger.fine("You are trying to put activity-deployment pair into the mapper but there is already such activity stored.");
        }
        map.put(activity, deployment);
    }

    public Map<String, String> get() {
        return map;
    }

    public String getDeploymentName(String activity) {
        Validate.notNullOrEmpty((String)activity, (String)"The activity to want to know the deployment name of can not be a null object nor an empty string!");
        return map.get(activity);
    }

    public List<String> getActivities(String deploymentName) {
        ArrayList<String> activities = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(deploymentName)) continue;
            activities.add(entry.getKey());
        }
        return activities;
    }
}

