/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.jboss.arquillian.core.spi.Validate;

public class DeploymentInstrumentationMapper {
    private static final Logger logger = Logger.getLogger(DeploymentInstrumentationMapper.class.getName());
    private Map<String, InstrumentationConfiguration> map = new ConcurrentHashMap<String, InstrumentationConfiguration>();

    public void set(Map<String, InstrumentationConfiguration> resolvedInstrumentation) {
        Validate.notNull(resolvedInstrumentation, (String)"Resolved instrumentation passed can not be a null object!");
        this.map = resolvedInstrumentation;
    }

    public void put(String deploymentName, InstrumentationConfiguration resolvedInstrumentation) {
        Validate.notNullOrEmpty((String)deploymentName, (String)"Deployment name to save resolved instrumentation for can not be a null object nor an empty string!");
        Validate.notNull((Object)resolvedInstrumentation, (String)"Resolved instrumentation can not be a null object!");
        if (this.map.containsKey(deploymentName)) {
            logger.fine("You are trying to put instrumentation for already existing deployment name.");
        }
        this.map.put(deploymentName, resolvedInstrumentation);
    }

    public Map<String, InstrumentationConfiguration> get() {
        return this.map;
    }

    public InstrumentationConfiguration getDeploymentName(String deploymentName) {
        Validate.notNullOrEmpty((String)deploymentName, (String)"Deployment name to get the instrumentation configuration of can not be a null object nor an empty string!");
        return this.map.get(deploymentName);
    }
}

