/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.native_.configuration.DroneConfigurationHolder;
import org.arquillian.droidium.native_.deployment.DeploymentWebDriverMapper;
import org.arquillian.droidium.native_.deployment.ExtensionDroneMapper;
import org.arquillian.droidium.native_.instrumentation.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.arquillian.droidium.native_.spi.event.AfterInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.BeforeInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.PerformInstrumentation;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;

public class InstrumentationPerformDecider {
    private static final Logger logger = Logger.getLogger(InstrumentationPerformDecider.class.getName());
    @Inject
    private Instance<DeploymentInstrumentationMapper> instrumentationMapper;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Instance<ExtensionDroneMapper> extensionDroneMapper;
    @Inject
    private Instance<DeploymentWebDriverMapper> deploymentWebDriverMapper;
    @Inject
    private Event<BeforeInstrumentationPerformed> beforeInstrumentationPerformed;
    @Inject
    private Event<PerformInstrumentation> performInstumentation;
    @Inject
    private Event<AfterInstrumentationPerformed> afterInstrumentationPerformed;

    public void decidePerformingInstrumentation(@Observes BeforeDroneInstantiated event) {
        String deploymentName = null;
        for (Map.Entry<String, DroneConfigurationHolder> entry : ((ExtensionDroneMapper)this.extensionDroneMapper.get()).get().entrySet()) {
            if (!entry.getValue().getQualifier().equals(event.getQualifier().getSimpleName().toLowerCase())) continue;
            deploymentName = ((DeploymentWebDriverMapper)this.deploymentWebDriverMapper.get()).getDeploymentName(entry.getKey());
        }
        if (deploymentName == null) {
            logger.log(Level.FINE, "There is not any matching deployment name to be instrumented. You wanted to instrument some @Deployment with backed WebDriver instance but you have not specified @Instrumentable annotation on that @Deployment. There has to be always at least one @Instrumentable deployment.");
            return;
        }
        InstrumentationConfiguration instrumentationConfiguration = ((DeploymentInstrumentationMapper)this.instrumentationMapper.get()).getDeploymentName(deploymentName);
        if (instrumentationConfiguration != null) {
            logger.log(Level.FINE, "instrumentation against deployment {0}", new Object[]{deploymentName});
            this.beforeInstrumentationPerformed.fire((Object)new BeforeInstrumentationPerformed(deploymentName, instrumentationConfiguration));
            this.performInstumentation.fire((Object)new PerformInstrumentation(deploymentName, instrumentationConfiguration));
            this.afterInstrumentationPerformed.fire((Object)new AfterInstrumentationPerformed(deploymentName, instrumentationConfiguration));
        }
    }
}

