/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.DroidiumDeployment;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.native_.configuration.DroneConfigurationHolder;
import org.arquillian.droidium.native_.deployment.DeploymentWebDriverMapper;
import org.arquillian.droidium.native_.deployment.ExtensionDroneMapper;
import org.arquillian.droidium.native_.deployment.SelendroidDeploymentRegister;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.droidium.native_.spi.event.SelendroidUndeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.event.AfterDroneDestroyed;

public class InstrumentationRemoveDecider {
    private static final Logger logger = Logger.getLogger(InstrumentationRemoveDecider.class.getName());
    @Inject
    private Instance<DeploymentWebDriverMapper> deploymentWebDriverMapper;
    @Inject
    private Instance<ExtensionDroneMapper> extensionDroneMapper;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Instance<SelendroidDeploymentRegister> selendroidDeploymentRegister;
    @Inject
    private Event<SelendroidUndeploy> selendroidUndeploy;

    public void decideRemovingInstrumentation(@Observes AfterDroneDestroyed event) {
        String qualifier = event.getQualifier().getSimpleName().toLowerCase();
        logger.log(Level.FINE, "Uninstallation of Selendroid server for Drone qualifier: {0}", new Object[]{qualifier});
        SelendroidDeployment selendroidDeployment = null;
        for (Map.Entry<String, DroneConfigurationHolder> extensionDroneEntry : ((ExtensionDroneMapper)this.extensionDroneMapper.get()).get().entrySet()) {
            if (!extensionDroneEntry.getValue().getQualifier().equals(qualifier)) continue;
            String deploymentName = ((DeploymentWebDriverMapper)this.deploymentWebDriverMapper.get()).getDeploymentName(extensionDroneEntry.getKey());
            logger.log(Level.FINE, "Uninstallation of Selendroid server for deployment {0} is going to be performed.", new Object[]{deploymentName});
            selendroidDeployment = ((SelendroidDeploymentRegister)((Object)this.selendroidDeploymentRegister.get())).get(deploymentName);
            break;
        }
        if (selendroidDeployment != null) {
            this.selendroidUndeploy.fire((Object)new SelendroidUndeploy(selendroidDeployment));
            ((SelendroidDeploymentRegister)((Object)this.selendroidDeploymentRegister.get())).remove((DroidiumDeployment)selendroidDeployment);
        } else {
            logger.log(Level.FINE, "There is not such instrumented deployment for Drone qualifier {0}", new Object[]{qualifier});
        }
    }
}

