/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.arquillian.droidium.native_.activity.ActivityNotFoundException;
import org.arquillian.droidium.native_.activity.NotUniqueWebDriverInstanceException;
import org.jboss.arquillian.core.spi.Validate;
import org.openqa.selenium.WebDriver;

public class ActivityWebDriverMapper {
    private static Map<String, WebDriver> map = new ConcurrentHashMap<String, WebDriver>();

    public void put(WebDriver instance, List<String> activities) {
        Validate.notNull((Object)instance, (String)"Drone instance can not be a null object!");
        Validate.notNull(activities, (String)"Activity object can not be a null object!");
        for (String activity : activities) {
            map.put(activity, instance);
        }
    }

    public WebDriver getInstance(String activity) throws ActivityNotFoundException, NotUniqueWebDriverInstanceException {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to get an instance of Drone can not be a null object nor an empty string!");
        WebDriver instance = this.getAsFQDN(activity);
        if (instance == null) {
            instance = this.getAsSimpleName(activity);
        }
        return instance;
    }

    private WebDriver getAsSimpleName(String activity) {
        ArrayList<WebDriver> foundDrivers = new ArrayList<WebDriver>();
        boolean activityFound = false;
        for (Map.Entry<String, WebDriver> entry : map.entrySet()) {
            if (!entry.getKey().endsWith(activity)) continue;
            foundDrivers.add(entry.getValue());
            activityFound = true;
        }
        if (!activityFound) {
            throw new ActivityNotFoundException(String.format("Activity '%s' was not found.", activity));
        }
        if (foundDrivers.size() > 1) {
            throw new NotUniqueWebDriverInstanceException("There is more than one WebDriver instance found for activity class of name '" + activity + "'. It is highly probable that there are two classes " + "which FQDN name differs but their simple name does not.");
        }
        return (WebDriver)foundDrivers.get(0);
    }

    private WebDriver getAsFQDN(String activity) {
        return map.get(activity);
    }

    public String getActivity(WebDriver driver, String activity) {
        for (Map.Entry<String, WebDriver> entry : map.entrySet()) {
            if (entry.getValue() != driver || !entry.getKey().equals(activity) && !entry.getKey().endsWith(activity)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void removeActivities(WebDriver driver) {
        for (Map.Entry<String, WebDriver> entry : map.entrySet()) {
            if (entry.getValue() != driver) continue;
            map.remove(entry.getKey());
        }
    }
}

