/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.io.File;
import org.arquillian.droidium.container.api.DroidiumDeployment;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.container.impl.AndroidApplicationHelper;
import org.arquillian.droidium.container.sign.APKSigner;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.deployment.SelendroidDeploymentRegister;
import org.arquillian.droidium.native_.selendroid.SelendroidRebuilder;
import org.arquillian.droidium.native_.selendroid.SelendroidServerManager;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.droidium.native_.spi.event.AfterInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.BeforeInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.PerformInstrumentation;
import org.arquillian.droidium.native_.spi.event.SelendroidDeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class InstrumentationPerformer {
    private static int counter = 0;
    @Inject
    private Instance<DroidiumNativeConfiguration> configuration;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Instance<SelendroidDeploymentRegister> selendroidDeploymentRegister;
    @Inject
    private Instance<SelendroidRebuilder> selendroidRebuilder;
    @Inject
    private Instance<AndroidApplicationHelper> applicationHelper;
    @Inject
    private Instance<APKSigner> signer;
    @Inject
    private Instance<SelendroidServerManager> selendroidServerManager;
    @Inject
    private Event<BeforeInstrumentationPerformed> beforeInstrumentationPerformed;
    @Inject
    private Event<AfterInstrumentationPerformed> afterInstrumentationPerformed;
    @Inject
    private Event<SelendroidDeploy> selendroidDeploy;

    public void performInstrumentation(@Observes PerformInstrumentation event) {
        this.beforeInstrumentationPerformed.fire((Object)new BeforeInstrumentationPerformed(event.getDeploymentName(), event.getConfiguration()));
        AndroidDeployment instrumentedDeployment = ((AndroidDeploymentRegister)this.androidDeploymentRegister.get()).get(event.getDeploymentName());
        File selendroidWorkingCopy = this.getSelendroidWorkingCopy();
        String selendroidPackageName = this.getSelendroidPackageName(selendroidWorkingCopy);
        String applicationBasePackage = instrumentedDeployment.getApplicationBasePackage();
        File selendroidRebuilt = ((SelendroidRebuilder)this.selendroidRebuilder.get()).rebuild(selendroidWorkingCopy, selendroidPackageName, applicationBasePackage);
        File selendroidResigned = this.getSelendroidResigned(selendroidRebuilt);
        SelendroidDeployment deployment = new SelendroidDeployment();
        deployment.setWorkingCopy(selendroidWorkingCopy).setRebuilt(selendroidRebuilt).setResigned(selendroidResigned).setServerBasePackage(((AndroidApplicationHelper)this.applicationHelper.get()).getApplicationBasePackage(selendroidResigned)).setSelendroidPackageName(selendroidPackageName).setInstrumentedDeployment(instrumentedDeployment).setDeploymentName(event.getDeploymentName()).setInstrumentationConfiguration(event.getConfiguration());
        ((SelendroidDeploymentRegister)((Object)this.selendroidDeploymentRegister.get())).add((DroidiumDeployment)deployment);
        this.selendroidDeploy.fire((Object)new SelendroidDeploy(deployment));
        ((SelendroidServerManager)this.selendroidServerManager.get()).instrument(deployment);
        this.afterInstrumentationPerformed.fire((Object)new AfterInstrumentationPerformed(event.getDeploymentName(), event.getConfiguration()));
    }

    private File getSelendroidResigned(File selendroidRebuilt) {
        return ((APKSigner)this.signer.get()).resign(selendroidRebuilt);
    }

    private File getSelendroidWorkingCopy() {
        return DroidiumFileUtils.copyFileToDirectory((File)((DroidiumNativeConfiguration)this.configuration.get()).getServerApk(), (File)DroidiumFileUtils.getTmpDir());
    }

    private String getSelendroidPackageName(File selendroidWorkingCopy) {
        return ((AndroidApplicationHelper)this.applicationHelper.get()).getApplicationBasePackage(selendroidWorkingCopy) + "_" + ++counter;
    }
}

