/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.spi.event.DroidiumExtensionConfigured;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.spi.event.DroidiumNativeConfigured;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DroidiumNativeConfigurator {
    private static final Logger logger = Logger.getLogger(DroidiumNativeConfigurator.class.getName());
    public static final String DROIDIUM_NATIVE_EXTENSION_NAME = "droidium-native";
    @Inject
    @ApplicationScoped
    private InstanceProducer<DroidiumNativeConfiguration> droidiumNativeConfiguration;
    @Inject
    private Event<DroidiumNativeConfigured> droidiumNativeConfigured;

    public void onDroidiumExtensionConfigured(@Observes DroidiumExtensionConfigured event, ArquillianDescriptor descriptor) {
        logger.info("Configuring droidium-native");
        DroidiumNativeConfiguration configuration = new DroidiumNativeConfiguration();
        for (ExtensionDef extensionDef : descriptor.getExtensions()) {
            if (!DROIDIUM_NATIVE_EXTENSION_NAME.equals(extensionDef.getExtensionName())) continue;
            Map properties = extensionDef.getExtensionProperties();
            configuration.setProperties(properties);
            break;
        }
        configuration.validate();
        this.droidiumNativeConfiguration.set((Object)configuration);
        this.droidiumNativeConfigured.fire((Object)new DroidiumNativeConfigured());
        if (logger.isLoggable(Level.INFO)) {
            System.out.println("Configuration of Arquillian Droidium Native");
            System.out.println(configuration);
        }
    }
}

