/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.spi.event.DroidiumNativeConfigured;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.execution.TimeoutExecutionException;
import org.arquillian.spacelift.tool.basic.DownloadTool;
import org.arquillian.spacelift.tool.basic.UnzipTool;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SelendroidDownloader {
    private static final Logger logger = Logger.getLogger(SelendroidDownloader.class.getName());
    private static final int DOWNLOAD_TIMEOUT_IN_MINUTES = 5;
    private static final String SELENDROID_SERVER_URL = "https://github.com/selendroid/selendroid/releases/download/0.13.0/selendroid-standalone-0.13.0-with-dependencies.jar";
    private static final String SELENDROID_SERVER_HOME = "target/selendroid-standalone-0.13.0-with-dependencies.jar";
    private static final String SELENDROID_UNZIP = "target/selendroid";
    @Inject
    private Instance<DroidiumNativeConfiguration> configuration;

    public void onDroidiumNativeConfigured(@Observes DroidiumNativeConfigured event) {
        DroidiumNativeConfiguration configuration = (DroidiumNativeConfiguration)this.configuration.get();
        if (!Validate.isReadable((File)configuration.getServerApk()) || !Validate.isReadable((File)configuration.getDriverApk())) {
            configuration.setProperty("serverApk", DroidiumNativeConfiguration.SERVER_HOME);
            configuration.setProperty("driverApk", DroidiumNativeConfiguration.DRIVER_HOME);
            if (!Validate.isReadable((File)configuration.getServerApk()) || !Validate.isReadable((File)configuration.getDriverApk())) {
                logger.info("You must provide a valid path both to Android Server APK and Android driver APK for Arquillian Droidium native plugin. Please be sure you have the read access to specified files. Both APKs are going to be downloaded for you automatically right now.");
                try {
                    File unzipped = (File)((UnzipTool)((DownloadTool)Tasks.prepare(DownloadTool.class)).from(SELENDROID_SERVER_URL).to(SELENDROID_SERVER_HOME).then(UnzipTool.class)).toDir(SELENDROID_UNZIP).execute().awaitAtMost(5L, TimeUnit.MINUTES);
                    DroidiumFileUtils.copyFileToDirectory((File)new File(unzipped, "/prebuild/selendroid-server-0.13.0.apk"), (File)new File(System.getProperty("user.home") + "/.droidium"));
                    DroidiumFileUtils.copyFileToDirectory((File)new File(unzipped, "/prebuild/android-driver-app-0.13.0.apk"), (File)new File(System.getProperty("user.home") + "/.droidium"));
                }
                catch (TimeoutExecutionException ex) {
                    throw new TimeoutExecutionException(String.format("Unable to download Selendroid from %s in %s minutes.", SELENDROID_SERVER_URL, 5), new Object[0]);
                }
            }
        }
    }
}

