/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.arquillian.core.spi.Validate;

public class DeploymentActivitiesMapper {
    private static final Logger logger = Logger.getLogger(DeploymentActivitiesMapper.class.getName());
    private final Map<String, List<String>> deploymentActivitiesMap = new ConcurrentHashMap<String, List<String>>();

    public void put(String deployment, List<String> activities) {
        Validate.notNull(activities, (String)"Activity list a null object!");
        Validate.notNullOrEmpty((String)deployment, (String)"Deployment name of underlying package where activities are located can not be a null object nor an empty string! Please specify deployment name of @Deployment where the activities are located.");
        if (activities.size() == 0) {
            logger.fine("You can not add list of activities which is empty.");
            return;
        }
        if (this.deploymentActivitiesMap.containsKey(deployment)) {
            logger.fine("You are trying to put activity-deployment pair into the mapper but there is already such deployment stored.");
            return;
        }
        this.deploymentActivitiesMap.put(deployment, activities);
    }

    public Map<String, List<String>> get() {
        return Collections.unmodifiableMap(this.deploymentActivitiesMap);
    }

    public String getDeploymentName(String activity) {
        Validate.notNullOrEmpty((String)activity, (String)"The activity to want to know the deployment name of can not be a null object nor an empty string!");
        for (Map.Entry<String, List<String>> entry : this.deploymentActivitiesMap.entrySet()) {
            if (!entry.getValue().contains(activity)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<String> getActivities(String deploymentName) {
        return Collections.unmodifiableList(this.deploymentActivitiesMap.get(deploymentName));
    }
}

