/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.io.File;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.container.api.DroidiumDeployment;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.container.impl.AndroidApplicationHelper;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.tool.APKResignerTool;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.deployment.SelendroidDeploymentRegister;
import org.arquillian.droidium.native_.metadata.DroidiumMetadataKey;
import org.arquillian.droidium.native_.selendroid.SelendroidRebuilder;
import org.arquillian.droidium.native_.selendroid.SelendroidServerManager;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.droidium.native_.spi.event.PerformInstrumentation;
import org.arquillian.droidium.native_.spi.event.SelendroidDeploy;
import org.arquillian.spacelift.execution.Tasks;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;

public class InstrumentationPerformer {
    private static int counter = 0;
    @Inject
    private Instance<AndroidSDK> sdk;
    @Inject
    private Instance<AndroidDeviceRegister> androidDeviceRegister;
    @Inject
    private Instance<DroidiumNativeConfiguration> configuration;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Instance<SelendroidDeploymentRegister> selendroidDeploymentRegister;
    @Inject
    private Instance<SelendroidRebuilder> selendroidRebuilder;
    @Inject
    private Instance<AndroidApplicationHelper> applicationHelper;
    @Inject
    private Instance<SelendroidServerManager> selendroidServerManager;
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<SelendroidDeploy> selendroidDeploy;

    public void performInstrumentation(@Observes PerformInstrumentation event) {
        AndroidDeployment instrumentedDeployment = ((AndroidDeploymentRegister)this.androidDeploymentRegister.get()).get(event.getDeploymentName());
        File selendroidWorkingCopy = this.getSelendroidWorkingCopy();
        String selendroidPackageName = ((AndroidApplicationHelper)this.applicationHelper.get()).getApplicationBasePackage(selendroidWorkingCopy);
        String instrumentationTestPackageName = String.format("%s_%d", selendroidPackageName, ++counter);
        String applicationBasePackage = instrumentedDeployment.getApplicationBasePackage();
        String selendroidVersion = ((AndroidApplicationHelper)this.applicationHelper.get()).getApplicationVersion(selendroidWorkingCopy);
        File selendroidRebuilt = ((SelendroidRebuilder)this.selendroidRebuilder.get()).rebuild(selendroidWorkingCopy, selendroidPackageName, instrumentationTestPackageName, applicationBasePackage, selendroidVersion);
        File selendroidResigned = this.getSelendroidResigned(selendroidRebuilt);
        SelendroidDeployment selendroidDeployment = new SelendroidDeployment();
        selendroidDeployment.setWorkingCopy(selendroidWorkingCopy).setRebuilt(selendroidRebuilt).setResigned(selendroidResigned).setInstrumentationTestPackageName(instrumentationTestPackageName).setSelendroidPackageName(selendroidPackageName).setSelendroidVersion(selendroidVersion).setInstrumentedDeployment(instrumentedDeployment).setDeploymentName(event.getDeploymentName()).setInstrumentationConfiguration(event.getConfiguration());
        ((SelendroidDeploymentRegister)((Object)this.selendroidDeploymentRegister.get())).add((DroidiumDeployment)selendroidDeployment);
        ((DroneContext)this.droneContext.get()).get(event.getDronePoint()).setMetadata(DroidiumMetadataKey.INSTRUMENTATION_TEST_PACKAGE_NAME.class, (Object)selendroidDeployment.getInstrumenationTestPackageName());
        ((DroneContext)this.droneContext.get()).get(event.getDronePoint()).setMetadata(DroidiumMetadataKey.TESTED_APP_PACKAGE_NAME.class, (Object)instrumentedDeployment.getApplicationBasePackage());
        this.selendroidDeploy.fire((Object)new SelendroidDeploy(selendroidDeployment));
        AndroidDevice device = ((AndroidDeviceRegister)this.androidDeviceRegister.get()).getByDeploymentName(selendroidDeployment.getDeploymentName());
        ((SelendroidServerManager)this.selendroidServerManager.get()).setDevice(device).instrument(selendroidDeployment);
    }

    private File getSelendroidResigned(File selendroidRebuilt) {
        return (File)((APKResignerTool)Tasks.chain((Object)selendroidRebuilt, APKResignerTool.class)).sdk((AndroidSDK)this.sdk.get()).execute().await();
    }

    private File getSelendroidWorkingCopy() {
        return DroidiumFileUtils.copyFileToDirectory((File)((DroidiumNativeConfiguration)this.configuration.get()).getServerApk(), (File)((AndroidSDK)this.sdk.get()).getPlatformConfiguration().getTmpDir());
    }
}

