/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.native_.exception.SelendroidRebuilderException;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.arquillian.spacelift.task.io.FileReader;
import org.arquillian.spacelift.tool.basic.StringReplacementTool;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class SelendroidRebuilder {
    private static final Logger logger = Logger.getLogger(SelendroidRebuilder.class.getName());
    private final AndroidSDK androidSDK;
    private static final String SELENDROID_VERSION_KEY = "${selendroidVersion}";
    private static final String MAIN_PACKAGE_KEY = "${mainPackage}";
    private static final String SERVER_INSTRUMENTATION_CLASSNAME_KEY = "${instrumentationClassName}";
    private static final String LIGHTWEIGHT_INSTRUMENTATION_CLASSNAME_KEY = "${lwInstrumentationClassName}";
    private static final String TARGET_PACKAGE_KEY = "${targetPackage}";

    public SelendroidRebuilder(AndroidSDK androidSDK) {
        Validate.notNull((Object)androidSDK, (String)"Android SDK for Selendroid rebuilder can not be null a null object!");
        this.androidSDK = androidSDK;
    }

    public File rebuild(File selendroidWorkingCopy, String selendroidPackageName, String modifiedSelendroidPackageName, String applicationBasePackage, String selendroidVersion) {
        FileOutputStream finalAndroidManifestStream;
        Validate.notNull((Object)selendroidWorkingCopy, (String)"Working copy of Selendroid server to rebuild can not be a null object!");
        Validate.notNullOrEmpty((String)selendroidPackageName, (String)"Selendroid package name for rebuilding of Selendroid server can not be a null object nor an empty string!");
        Validate.notNullOrEmpty((String)modifiedSelendroidPackageName, (String)"Selendroid package name for rebuilding of Selendroid server can not be a null object nor an empty string!");
        Validate.notNullOrEmpty((String)applicationBasePackage, (String)"Application base package for rebuilding of Selendroid server can not be a null object nor an empty string!");
        Validate.notNull((Object)applicationBasePackage, (String)"Selendroid version for rebuilding of Selendroid server can not be a null object!");
        File tmpDir = this.androidSDK.getPlatformConfiguration().getTmpDir();
        File finalAndroidManifest = new File(tmpDir, "AndroidManifest.xml");
        File dummyAPK = new File(tmpDir, "dummy.apk");
        try {
            finalAndroidManifestStream = new FileOutputStream(finalAndroidManifest.getAbsoluteFile());
        }
        catch (FileNotFoundException ex) {
            throw new SelendroidRebuilderException();
        }
        InputStream androidManifestStream = this.getClass().getClassLoader().getResourceAsStream("AndroidManifest.xml");
        if (androidManifestStream == null) {
            throw new SelendroidRebuilderException("the class loader of " + this.getClass().getName() + " could not find AndroidManifest.xml resource");
        }
        try {
            finalAndroidManifestStream.write(IOUtils.toByteArray((InputStream)androidManifestStream));
        }
        catch (IOException ex) {
            throw new SelendroidRebuilderException("unable to write to " + finalAndroidManifest.getAbsolutePath());
        }
        this.closeStream(finalAndroidManifestStream);
        this.closeStream(androidManifestStream);
        HashMap<String, String> replacementMapping = new HashMap<String, String>(4);
        replacementMapping.put(Pattern.quote(SELENDROID_VERSION_KEY), selendroidVersion);
        replacementMapping.put(Pattern.quote(MAIN_PACKAGE_KEY), modifiedSelendroidPackageName);
        replacementMapping.put(Pattern.quote(TARGET_PACKAGE_KEY), applicationBasePackage);
        replacementMapping.put(Pattern.quote(SERVER_INSTRUMENTATION_CLASSNAME_KEY), selendroidPackageName + ".ServerInstrumentation");
        replacementMapping.put(Pattern.quote(LIGHTWEIGHT_INSTRUMENTATION_CLASSNAME_KEY), selendroidPackageName + ".LightweightInstrumentation");
        this.modifyManifest(finalAndroidManifest, replacementMapping);
        this.createDummyAPK(dummyAPK, finalAndroidManifest);
        Archive dummyArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)dummyAPK);
        Archive finalArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)selendroidWorkingCopy);
        finalArchive.delete("AndroidManifest.xml");
        finalArchive.add(dummyArchive.get("AndroidManifest.xml").getAsset(), "AndroidManifest.xml");
        File targetFile = new File(this.androidSDK.getPlatformConfiguration().getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        return DroidiumFileUtils.export((Archive)finalArchive, (File)targetFile);
    }

    private void createDummyAPK(File dummyAPK, File androidManifest) {
        Command createDummyPackage = new CommandBuilder((CharSequence)this.androidSDK.getAaptPath()).parameter((CharSequence)"package").parameter((CharSequence)"-f").parameter((CharSequence)"-M").parameter((CharSequence)androidManifest.getAbsolutePath()).parameter((CharSequence)"-I").parameter((CharSequence)new File(this.androidSDK.getPlatformDirectory(), "android.jar").getAbsolutePath()).parameter((CharSequence)"-F").parameter((CharSequence)dummyAPK.getAbsolutePath()).build();
        ProcessResult processResult = (ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).command(createDummyPackage).execute().await();
        if (processResult != null && processResult.exitValue() != 0) {
            throw new SelendroidRebuilderException("Command failed to execute: " + createDummyPackage.toString() + "with output " + processResult.output());
        }
    }

    private File modifyManifest(File manifest, Map<String, String> replacementMapping) {
        StringReplacementTool sed = ((StringReplacementTool)Tasks.prepare(StringReplacementTool.class)).in(new File[]{manifest});
        for (Map.Entry<String, String> replacement : replacementMapping.entrySet()) {
            sed.replace(replacement.getKey()).with(replacement.getValue());
        }
        List newManifest = (List)sed.execute().await();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, (String)((Map)((FileReader)Tasks.chain((Object)newManifest, FileReader.class)).execute().await()).entrySet().iterator().next().getValue());
        }
        return (File)newManifest.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            stream = null;
        }
    }
}

