/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.webdriver;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.webdriver.AndroidBrowserCapabilities;
import org.arquillian.droidium.native_.webdriver.AndroidDriver;
import org.arquillian.droidium.native_.webdriver.SecurityActions;
import org.arquillian.droidium.native_.webdriver.Validate;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AndroidDriverFactory
implements Configurator<AndroidDriver, WebDriverConfiguration>,
Instantiator<AndroidDriver, WebDriverConfiguration>,
Destructor<AndroidDriver> {
    private static final Logger logger = Logger.getLogger(AndroidDriverFactory.class.getName());

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(AndroidDriver driver) {
        driver.quit();
    }

    public AndroidDriver createInstance(WebDriverConfiguration configuration) {
        URL remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            remoteAddress = WebDriverConfiguration.DEFAULT_REMOTE_URL;
            logger.log(Level.INFO, "Property \"remoteAdress\" was not specified, using default value of {0} for AndroidDriver", WebDriverConfiguration.DEFAULT_REMOTE_URL);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{URL.class, Capabilities.class}, new Object[]{remoteAddress, new DesiredCapabilities(configuration.getCapabilities())}, AndroidDriver.class);
    }

    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, DronePoint<AndroidDriver> injectionPoint) {
        WebDriverConfiguration configuration = new WebDriverConfiguration((BrowserCapabilities)new AndroidBrowserCapabilities());
        configuration.configure(descriptor, injectionPoint.getQualifier());
        return configuration;
    }
}

