/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.webdriver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Class<?> getClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        try {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            return Class.forName(className, false, tccl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find implementation class " + className + " on current classpath. Please make sure it is present on the classpath.");
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Class<?> implClass = SecurityActions.getClass(className);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find a constructor for implementation class " + SecurityActions.getConstructorName(className, argumentTypes) + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + ". Please make sure that you haven't misconfigured Arquillian Drone, " + "e.g. you set an implementationClass which does not match the field/parameter type in your code.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to instantiate a " + className + " instance, access refused by SecurityManager.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Unable to instantiate Drone via %s: %s", SecurityActions.getConstructorName(className, argumentTypes), e.getCause()), e.getCause());
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Unable to instantiate " + expectedType.getName() + " instance. Constructed object was type of " + obj.getClass().getName() + ", which is not compatible. Please make sure you haven't misconfigured Arquillian Drone.");
        }
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static String setProperty(final String key, final String value) {
        try {
            String oldValue = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    if (value == null) {
                        return System.clearProperty(key);
                    }
                    return System.setProperty(key, value);
                }
            });
            return oldValue;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    private static String getConstructorName(String className, Class<?>[] argumentTypes) {
        StringBuilder constructor = new StringBuilder(className).append("(");
        for (Class<?> arg : argumentTypes) {
            constructor.append(arg.getSimpleName()).append(",");
        }
        if (constructor.charAt(constructor.length() - 1) == ',') {
            constructor.deleteCharAt(constructor.length() - 1);
        }
        constructor.append(")");
        return constructor.toString();
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

