/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.arquillian.droidium.native_.configuration.DroidiumDronePointFilter;
import org.arquillian.droidium.native_.deployment.DeploymentActivitiesMapper;
import org.arquillian.droidium.native_.deployment.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.metadata.DroidiumMetadataKey;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointContext;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.openqa.selenium.WebDriver;

public class DroidiumDronePointModifier {
    @Inject
    private Instance<DeploymentInstrumentationMapper> deploymentInstrumentationMapper;
    @Inject
    private Instance<DeploymentActivitiesMapper> activityDeploymentMapper;
    @Inject
    private Instance<DroneContext> droneContext;

    public void onAfterDroneConfigured(@Observes AfterDroneConfigured event) {
        if (!event.getDronePoint().conformsTo(WebDriver.class)) {
            return;
        }
        DronePoint dronePoint = event.getDronePoint();
        DroneContext droneContext = (DroneContext)this.droneContext.get();
        DronePointContext dronePointContext = droneContext.get(dronePoint);
        if (new DroidiumDronePointFilter().accepts(droneContext, (DronePoint<? extends WebDriver>)dronePoint)) {
            WebDriverConfiguration configuration = (WebDriverConfiguration)dronePointContext.getConfigurationAs(WebDriverConfiguration.class);
            String port = this.parsePort(configuration.getRemoteAddress());
            dronePointContext.setMetadata(DroidiumMetadataKey.PORT.class, (Object)port);
            String deploymentName = this.getDeploymentName((DeploymentInstrumentationMapper)this.deploymentInstrumentationMapper.get(), port);
            if (deploymentName != null) {
                dronePointContext.setMetadata(DroidiumMetadataKey.DEPLOYMENT.class, (Object)deploymentName);
            }
        }
    }

    public void onAfterDroneInstantiated(@Observes AfterDroneInstantiated event) {
        if (!event.getDronePoint().conformsTo(WebDriver.class)) {
            return;
        }
        DroneContext droneContext = (DroneContext)this.droneContext.get();
        DronePointContext dronePointContext = droneContext.get(event.getDronePoint());
        if (dronePointContext.hasMetadata(DroidiumMetadataKey.DEPLOYMENT.class)) {
            String deploymentName = (String)dronePointContext.getMetadata(DroidiumMetadataKey.DEPLOYMENT.class);
            List<String> activities = ((DeploymentActivitiesMapper)this.activityDeploymentMapper.get()).getActivities(deploymentName);
            dronePointContext.setMetadata(DroidiumMetadataKey.ACTIVITIES.class, activities);
        }
    }

    private String getDeploymentName(DeploymentInstrumentationMapper mapper, String port) {
        for (Map.Entry<String, InstrumentationConfiguration> entry : mapper.get().entrySet()) {
            if (!entry.getValue().getPort().equals(port)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String parsePort(URL remoteUrl) {
        int port = remoteUrl.getPort();
        if (port == -1) {
            port = WebDriverConfiguration.DEFAULT_REMOTE_URL.getPort();
        }
        return Integer.toString(port);
    }
}

