/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.droidium.container.configuration.Validate;

public class DroidiumNativeConfiguration {
    public static final String SELENDROID_VERSION = "0.17.0";
    public static final String SERVER_HOME = System.getProperty("user.home") + "/.droidium/selendroid-server-" + "0.17.0" + ".apk";
    private String serverApk = SERVER_HOME;
    private Map<String, String> properties = new HashMap<String, String>();

    public File getServerApk() {
        return new File(this.getProperty("serverApk", this.serverApk));
    }

    public void setProperties(Map<String, String> properties) throws IllegalArgumentException {
        Validate.notNull(properties, (String)"Properties to set for Arquillian Droidium native configuration can not be a null object!");
        this.properties = properties;
    }

    public String getProperty(String name, String defaultValue) throws IllegalStateException {
        Validate.notNullOrEmpty((String)name, (String)"unable to get configuration value of null configuration key");
        Validate.notNullOrEmpty((String)defaultValue, (String)("unable to set configuration value of " + name + " to null"));
        String found = this.properties.get(name);
        if (found == null || found.length() == 0) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String property, String value) throws IllegalStateException {
        Validate.notNullOrEmpty((String)property, (String)"unable to set configuration value which key is null");
        Validate.notNullOrEmpty((String)value, (String)"unable to set configuration value which is null");
        this.properties.put(property, value);
    }

    public void validate() throws IllegalArgumentException, IllegalStateException {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "serverApk", this.getServerApk()));
        return sb.toString();
    }
}

