/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.List;
import org.arquillian.droidium.container.impl.AndroidApplicationHelper;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.spi.event.AfterAndroidDeploymentDeployed;
import org.arquillian.droidium.native_.deployment.DeploymentActivitiesMapper;
import org.arquillian.droidium.native_.deployment.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.spi.event.AfterAndroidDeploymentScanned;
import org.arquillian.droidium.native_.spi.event.BeforeAndroidDeploymentScanned;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DeploymentActivitiesScanner {
    @Inject
    private Instance<DeploymentActivitiesMapper> deploymentActivitiesMapper;
    @Inject
    private Instance<DeploymentInstrumentationMapper> deploymentInstrumentationMapper;
    @Inject
    private Instance<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    private Event<BeforeAndroidDeploymentScanned> beforeAndroidDeploymentScanned;
    @Inject
    private Event<AfterAndroidDeploymentScanned> afterAndroidDeploymentScanned;

    public void onAndroidDeploymentDeployed(@Observes AfterAndroidDeploymentDeployed event) {
        AndroidDeployment deployment = event.getDeployment();
        if (((DeploymentInstrumentationMapper)this.deploymentInstrumentationMapper.get()).getInstumentationConfiguration(deployment.getDeploymentName()) != null) {
            this.beforeAndroidDeploymentScanned.fire((Object)new BeforeAndroidDeploymentScanned(deployment));
            List activities = ((AndroidApplicationHelper)this.androidApplicationHelper.get()).getActivities(deployment.getResignedApk());
            ((DeploymentActivitiesMapper)this.deploymentActivitiesMapper.get()).put(deployment.getDeploymentName(), activities);
            this.afterAndroidDeploymentScanned.fire((Object)new AfterAndroidDeploymentScanned(deployment));
        }
    }
}

