/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.Iterator;
import org.arquillian.droidium.container.spi.event.BeforeAndroidDeploymentUnDeployed;
import org.arquillian.droidium.native_.metadata.DroidiumMetadataKey;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointFilter;
import org.jboss.arquillian.drone.spi.command.DestroyDrone;
import org.openqa.selenium.WebDriver;

public class DroidiumDronePointDestroyer {
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<DestroyDrone> destroyDrone;

    public void destroyDrone(@Observes BeforeAndroidDeploymentUnDeployed event) {
        Iterator dronePointsIterator = ((DroneContext)this.droneContext.get()).find(WebDriver.class).filter((DronePointFilter)new DroidiumDestroyDronePointFilter(event.getUnDeployment().getDeploymentName())).iterator();
        while (dronePointsIterator.hasNext()) {
            this.destroyDrone.fire((Object)new DestroyDrone((DronePoint)dronePointsIterator.next()));
        }
    }

    private class DroidiumDestroyDronePointFilter
    implements DronePointFilter<WebDriver> {
        private String deploymentName;

        public DroidiumDestroyDronePointFilter(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public boolean accepts(DroneContext context, DronePoint<? extends WebDriver> dronePoint) {
            if (!context.get(dronePoint).hasMetadata(DroidiumMetadataKey.DEPLOYMENT.class)) {
                return false;
            }
            String deploymentName = (String)context.get(dronePoint).getMetadata(DroidiumMetadataKey.DEPLOYMENT.class);
            return deploymentName != null && this.deploymentName.equals(deploymentName);
        }
    }
}

