/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.enrichment;

import java.util.ArrayList;
import java.util.List;
import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.native_.configuration.DroidiumDronePointFilter;
import org.arquillian.droidium.native_.exception.NotUniqueWebDriverInstanceException;
import org.arquillian.droidium.native_.exception.WebDriverInstanceNotFoundException;
import org.arquillian.droidium.native_.metadata.DroidiumMetadataKey;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointContext;
import org.jboss.arquillian.drone.spi.DronePointFilter;
import org.openqa.selenium.WebDriver;

public class NativeActivityManager
implements ActivityManager {
    private DroneContext droneContext;

    void setDroneContext(DroneContext droneContext) {
        if (this.droneContext == null && droneContext != null) {
            this.droneContext = droneContext;
        }
    }

    public void startActivity(String activity) {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to start can not be a null object nor an empty string!");
        List<DronePoint<WebDriver>> dronePoints = this.getDronePointsForActivity(activity);
        this.checkSizes(dronePoints);
        DronePoint<WebDriver> dronePoint = dronePoints.get(0);
        if (activity.startsWith(".")) {
            activity = (String)this.droneContext.get(dronePoint).getMetadata(DroidiumMetadataKey.TESTED_APP_PACKAGE_NAME.class) + activity;
        }
        WebDriver instance = (WebDriver)this.droneContext.get(dronePoint).getInstance();
        instance.get("and-activity://" + activity);
    }

    public void startActivity(Class<?> activity) throws WebDriverInstanceNotFoundException {
        Validate.notNull(activity, (String)"Activity you want to start can not be a null object!");
        this.startActivity(activity.getName());
    }

    public void stopActivity(String activity) throws WebDriverInstanceNotFoundException {
        Validate.notNullOrEmpty((String)activity, (String)"Activity you want to stop can not be a null object nor an empty string!");
        List<DronePoint<WebDriver>> dronePoints = this.getDronePointsForActivity(activity);
        this.checkSizes(dronePoints);
        ((WebDriver)this.droneContext.get(dronePoints.get(0)).getInstanceAs(WebDriver.class)).close();
    }

    public void stopActivity(Class<?> activity) throws WebDriverInstanceNotFoundException {
        Validate.notNull(activity, (String)"Activity you want to stop can not be a null object!");
        this.stopActivity(activity.getName());
    }

    private List<DronePoint<WebDriver>> getDronePointsForActivity(String activityToStart) {
        ArrayList<DronePoint<WebDriver>> dronePoints = new ArrayList<DronePoint<WebDriver>>();
        if (activityToStart == null || activityToStart.isEmpty()) {
            return dronePoints;
        }
        for (DronePoint dronePoint : this.droneContext.find(WebDriver.class).filter((DronePointFilter)new DroidiumDronePointFilter())) {
            DronePointContext dronePointContext = this.droneContext.get(dronePoint);
            if (!dronePointContext.hasMetadata(DroidiumMetadataKey.ACTIVITIES.class) || !dronePointContext.hasMetadata(DroidiumMetadataKey.INSTRUMENTATION_TEST_PACKAGE_NAME.class) || !dronePointContext.hasMetadata(DroidiumMetadataKey.TESTED_APP_PACKAGE_NAME.class)) continue;
            List activities = (List)dronePointContext.getMetadata(DroidiumMetadataKey.ACTIVITIES.class);
            String androidPackageName = (String)dronePointContext.getMetadata(DroidiumMetadataKey.TESTED_APP_PACKAGE_NAME.class);
            if (activityToStart.startsWith(".")) {
                String fqcn = androidPackageName + activityToStart;
                if (!activities.contains(fqcn)) continue;
                dronePoints.add((DronePoint<WebDriver>)dronePoint);
                continue;
            }
            if (!activities.contains(activityToStart)) continue;
            dronePoints.add((DronePoint<WebDriver>)dronePoint);
        }
        return dronePoints;
    }

    private void checkSizes(List<DronePoint<WebDriver>> dronePoints) throws WebDriverInstanceNotFoundException, NotUniqueWebDriverInstanceException {
        if (dronePoints.size() == 0) {
            throw new WebDriverInstanceNotFoundException("It seems you are trying to control an activity which is not backed by any WebDriver instance.");
        }
        if (dronePoints.size() != 1) {
            throw new NotUniqueWebDriverInstanceException("Activity you want to control is found to be controllable by multiple WebDrivers.");
        }
    }
}

