/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.deployment.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.metadata.DroidiumMetadataKey;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.arquillian.droidium.native_.spi.event.AfterInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.BeforeInstrumentationPerformed;
import org.arquillian.droidium.native_.spi.event.PerformInstrumentation;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePointContext;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;

public class InstrumentationPerformDecider {
    private static final Logger logger = Logger.getLogger(InstrumentationPerformDecider.class.getName());
    @Inject
    private Instance<DeploymentInstrumentationMapper> instrumentationMapper;
    @Inject
    private Event<BeforeInstrumentationPerformed> beforeInstrumentationPerformed;
    @Inject
    private Event<PerformInstrumentation> performInstumentation;
    @Inject
    private Event<AfterInstrumentationPerformed> afterInstrumentationPerformed;
    @Inject
    private Instance<DroneContext> droneContext;

    public void decidePerformingInstrumentation(@Observes BeforeDroneInstantiated event) {
        DroneContext droneContext = (DroneContext)this.droneContext.get();
        DronePointContext dronePointContext = droneContext.get(event.getDronePoint());
        if (dronePointContext.hasMetadata(DroidiumMetadataKey.DEPLOYMENT.class)) {
            String deploymentName = (String)dronePointContext.getMetadata(DroidiumMetadataKey.DEPLOYMENT.class);
            InstrumentationConfiguration instrumentationConfiguration = ((DeploymentInstrumentationMapper)this.instrumentationMapper.get()).getInstumentationConfiguration(deploymentName);
            if (instrumentationConfiguration != null) {
                logger.log(Level.FINE, "instrumentation against deployment {0} is going to be performed", new Object[]{deploymentName});
                this.beforeInstrumentationPerformed.fire((Object)new BeforeInstrumentationPerformed(deploymentName, instrumentationConfiguration));
                this.performInstumentation.fire((Object)new PerformInstrumentation(event.getDronePoint(), deploymentName, instrumentationConfiguration));
                this.afterInstrumentationPerformed.fire((Object)new AfterInstrumentationPerformed(deploymentName, instrumentationConfiguration));
            }
        }
    }
}

