/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.instrumentation;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.native_.api.Instrumentable;
import org.arquillian.droidium.native_.exception.InstrumentationMapperException;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.spi.TestClass;

public class InstrumentationScanner {
    public static Map<String, InstrumentationConfiguration> scan(TestClass testClass) throws InstrumentationMapperException {
        Validate.notNull((Object)testClass, (String)"Test class to get the instrumentation mapping from can not be a null object!");
        ConcurrentHashMap<String, InstrumentationConfiguration> instrumentationMap = new ConcurrentHashMap<String, InstrumentationConfiguration>();
        for (Method method : testClass.getMethods(Deployment.class)) {
            if (method.getAnnotation(Instrumentable.class) == null) continue;
            instrumentationMap.put(InstrumentationScanner.getDeploymentName(method), InstrumentationScanner.getInstrumentationConfiguration(method));
        }
        InstrumentationScanner.validate(instrumentationMap);
        return instrumentationMap;
    }

    public static boolean validate(Map<String, InstrumentationConfiguration> instrumentation) throws InstrumentationMapperException {
        HashSet<InstrumentationConfiguration> tempSet = new HashSet<InstrumentationConfiguration>();
        for (Map.Entry<String, InstrumentationConfiguration> item : instrumentation.entrySet()) {
            if (tempSet.add(item.getValue())) continue;
            throw new InstrumentationMapperException("There is a duplicity in the instrumentation configuration. Check that the name of @Deployment is different for every deployment method and that port number in @Instrumentable is different for every @Deployment method as well.");
        }
        return true;
    }

    private static String getDeploymentName(Method method) {
        Validate.notNull((Object)method, (String)"Method to get the deployment name from can not be a null object!");
        Deployment deploymentAnnotation = method.getAnnotation(Deployment.class);
        if (deploymentAnnotation == null) {
            throw new IllegalArgumentException("You want to know the name of a deployment from a deployment method without @Deployment annotation.");
        }
        return deploymentAnnotation.name();
    }

    private static InstrumentationConfiguration getInstrumentationConfiguration(Method method) {
        Validate.notNull((Object)method, (String)"Method to get the instrumentation configuration from can not be a null object!");
        Instrumentable instrumentationAnnotation = method.getAnnotation(Instrumentable.class);
        if (instrumentationAnnotation == null) {
            throw new IllegalArgumentException("You want to get the instrumentation configuration from a deployment method without @Instrumentable annotation.");
        }
        InstrumentationConfiguration instrumentationConfiguration = new InstrumentationConfiguration();
        instrumentationConfiguration.setPort(instrumentationAnnotation.viaPort());
        return instrumentationConfiguration;
    }
}

