/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.native_.selendroid.SelendroidServerManager;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.droidium.native_.spi.event.AfterSelendroidDeploymentDeployed;
import org.arquillian.droidium.native_.spi.event.BeforeSelendroidDeploymentDeployed;
import org.arquillian.droidium.native_.spi.event.SelendroidDeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SelendroidDeploymentInstaller {
    @Inject
    private Instance<SelendroidServerManager> selendroidServerManager;
    @Inject
    private Instance<AndroidDeviceRegister> androidDeviceRegister;
    @Inject
    private Event<BeforeSelendroidDeploymentDeployed> beforeDeployed;
    @Inject
    private Event<AfterSelendroidDeploymentDeployed> afterDeployed;

    public void onSelendroidDeploy(@Observes SelendroidDeploy event) {
        SelendroidDeployment selendroidDeployment = event.getDeployment();
        this.beforeDeployed.fire((Object)new BeforeSelendroidDeploymentDeployed(selendroidDeployment));
        AndroidDevice device = ((AndroidDeviceRegister)this.androidDeviceRegister.get()).getByDeploymentName(selendroidDeployment.getDeploymentName());
        ((SelendroidServerManager)this.selendroidServerManager.get()).setDevice(device).install(selendroidDeployment);
        this.afterDeployed.fire((Object)new AfterSelendroidDeploymentDeployed(selendroidDeployment));
    }
}

