/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.native_.selendroid.SelendroidServerManager;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.droidium.native_.spi.event.AfterSelendroidDeploymentUnDeployed;
import org.arquillian.droidium.native_.spi.event.BeforeSelendroidDeploymentUnDeployed;
import org.arquillian.droidium.native_.spi.event.SelendroidUnDeploy;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SelendroidDeploymentUnInstaller {
    @Inject
    private Instance<SelendroidServerManager> selendroidServerManager;
    @Inject
    private Instance<AndroidDeviceRegister> androidDeviceRegister;
    @Inject
    private Event<BeforeSelendroidDeploymentUnDeployed> beforeUnDeployed;
    @Inject
    private Event<AfterSelendroidDeploymentUnDeployed> afterUnDeployed;

    public void onSelendroidUndeploy(@Observes SelendroidUnDeploy event) {
        SelendroidDeployment selendroidUnDeployment = event.getUnDeployment();
        this.beforeUnDeployed.fire((Object)new BeforeSelendroidDeploymentUnDeployed(selendroidUnDeployment));
        AndroidDevice device = ((AndroidDeviceRegister)this.androidDeviceRegister.get()).getByDeploymentName(selendroidUnDeployment.getDeploymentName());
        ((SelendroidServerManager)this.selendroidServerManager.get()).setDevice(device).uninstall(selendroidUnDeployment);
        this.afterUnDeployed.fire((Object)new AfterSelendroidDeploymentUnDeployed(selendroidUnDeployment));
    }
}

