/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.container.utils.Monkey;
import org.arquillian.droidium.native_.exception.InvalidSelendroidPortException;
import org.arquillian.droidium.native_.spi.SelendroidDeployment;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.os.CommandTool;

public class SelendroidServerManager {
    private static final Logger logger = Logger.getLogger(SelendroidServerManager.class.getName());
    private AndroidDevice device;
    private final AndroidSDK sdk;
    private static final String TOP_CMD = "top -n 1";
    private static final int SOCKET_TIME_OUT_SECONDS = 10;
    private static final int CONNECTION_TIME_OUT_SECONDS = 10;
    private static final int NUM_CONNECTION_RETIRES = 5;

    public SelendroidServerManager(AndroidDevice device, AndroidSDK sdk) {
        Validate.notNull((Object)sdk, (String)"Android SDK to set can not be a null object!");
        this.device = device;
        this.sdk = sdk;
    }

    public SelendroidServerManager(AndroidSDK sdk) {
        this(null, sdk);
    }

    public SelendroidServerManager setDevice(AndroidDevice device) {
        if (device != null) {
            this.device = device;
        }
        return this;
    }

    public void install(SelendroidDeployment deployment) {
        Validate.notNull((Object)this.device, (String)"Android device can not be a null object!");
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to deploy can not be a null object!");
        Validate.notNull((Object)deployment.getResigned(), (String)"Resigned Selendroid application to deploy can not be a null object!");
        Command selendroidInstallCommand = new CommandBuilder((CharSequence)this.sdk.getAdbPath()).parameter((CharSequence)"-s").parameter((CharSequence)this.device.getSerialNumber()).parameter((CharSequence)"install").parameter((CharSequence)deployment.getResigned().getAbsolutePath()).build();
        if (this.device.isPackageInstalled(deployment.getInstrumenationTestPackageName())) {
            this.device.uninstallPackage(deployment.getInstrumenationTestPackageName());
        }
        logger.fine("Selendroid server installation command: " + selendroidInstallCommand.toString());
        ProcessResult processResult = (ProcessResult)((CommandTool)Spacelift.task(CommandTool.class)).addEnvironment(this.sdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).command(selendroidInstallCommand).execute().await();
        if (processResult.exitValue() != 0) {
            throw new AndroidExecutionException("Unable to execute Selendroid installation process, exit value: " + processResult.exitValue());
        }
        if (!this.device.isPackageInstalled(deployment.getInstrumenationTestPackageName())) {
            throw new AndroidExecutionException("Modified Selendroid server was not installed on device.");
        }
    }

    public void instrument(SelendroidDeployment deployment) {
        Validate.notNull((Object)this.device, (String)"Android device can not be a null object!");
        Validate.notNull((Object)deployment, (String)"Deployment to instument is a null object!");
        Validate.notNull((Object)deployment.getInstrumentationConfiguration(), (String)"Instrumentation configuration of the underlying deployment is a null object!");
        Validate.notNull((Object)deployment.getInstrumentedDeployment(), (String)"Android deployment for Selendroid deployment is a null object!");
        int port = Integer.parseInt(deployment.getInstrumentationConfiguration().getPort());
        this.createPortForwarding(port, port);
        String instrumentedComponent = String.format("%s/%s.ServerInstrumentation", deployment.getInstrumenationTestPackageName(), deployment.getSelendroidPackageName());
        Command startApplicationInstrumentationCommand = new CommandBuilder((CharSequence)"am").parameter((CharSequence)"instrument").parameter((CharSequence)"-e").parameter((CharSequence)"main_activity").parameter((CharSequence)("'" + deployment.getInstrumentedDeployment().getApplicationMainActivity() + "'")).parameter((CharSequence)"-e").parameter((CharSequence)"server_port").parameter((CharSequence)deployment.getInstrumentationConfiguration().getPort()).parameter((CharSequence)instrumentedComponent).build();
        logger.fine(startApplicationInstrumentationCommand.toString());
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile((File)this.sdk.getPlatformConfiguration().getTmpDir()), deployment.getInstrumentedDeployment().getApplicationBasePackage(), true);
            this.device.executeShellCommand(startApplicationInstrumentationCommand.toString(), (AndroidDeviceOutputReciever)monkey);
            Monkey.wait((AndroidDevice)this.device, (Monkey)monkey, (String)TOP_CMD);
            this.waitUntilSelendroidServerCommunication(port);
        }
        catch (Exception ex) {
            this.removePortForwarding(port, port);
            throw new AndroidExecutionException(ex.getMessage());
        }
    }

    public void disable(SelendroidDeployment deployment) {
        Validate.notNull((Object)this.device, (String)"Android device can not be a null object!");
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to disable can not be a null object!");
        try {
            this.device.executeShellCommand(new CommandBuilder((CharSequence)"pm").parameter((CharSequence)"disable").parameter((CharSequence)deployment.getInstrumenationTestPackageName()).build().toString());
        }
        catch (AndroidExecutionException ex) {
            throw new AndroidExecutionException("Unable to disable Selendroid deployment " + deployment.getInstrumenationTestPackageName(), (Throwable)ex);
        }
    }

    public void uninstall(SelendroidDeployment deployment) {
        Validate.notNull((Object)this.device, (String)"Android device can not be a null object!");
        Validate.notNull((Object)deployment, (String)"Selendroid deployment to uninstall can not be a null object!");
        try {
            this.device.executeShellCommand(new CommandBuilder((CharSequence)"pm").parameter((CharSequence)"uninstall").parameter((CharSequence)deployment.getInstrumenationTestPackageName()).build().toString());
        }
        catch (AndroidExecutionException ex) {
            throw new AndroidExecutionException("Unable to uninstall Selendroid server.", (Throwable)ex);
        }
        finally {
            int port = Integer.parseInt(deployment.getInstrumentationConfiguration().getPort());
            this.removePortForwarding(port, port);
        }
    }

    private void waitUntilSelendroidServerCommunication(int port) {
        this.validatePort(port);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(config).disableContentCompression().build();
        HttpGet httpGet = new HttpGet(this.getSelendroidStatusURI(port));
        boolean connectionSuccess = false;
        for (int i = 5; i > 0; --i) {
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    connectionSuccess = true;
                    break;
                }
                logger.log(Level.INFO, i + ": Response was not 200 from port " + port + ", response was: " + statusCode);
                continue;
            }
            catch (ClientProtocolException e) {
                logger.log(Level.WARNING, e.getMessage());
                continue;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
        try {
            client.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        if (!connectionSuccess) {
            throw new AndroidExecutionException("Unable to get successful connection from Selendroid http server.");
        }
    }

    private URI getSelendroidStatusURI(int port) {
        try {
            return new URI("http://localhost:" + port + "/wd/hub/status");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private void createPortForwarding(int from, int to) {
        this.validatePort(from);
        this.validatePort(to);
        logger.log(Level.FINE, "Creating port forwarding from {0} to {1}", new Object[]{from, to});
        this.device.createPortForwarding(from, to);
    }

    private void removePortForwarding(int from, int to) {
        this.validatePort(from);
        this.validatePort(to);
        logger.log(Level.FINE, "Removing port forwarding from {0} to {1}", new Object[]{from, to});
        this.device.removePortForwarding(from, to);
    }

    private void validatePort(int port) {
        if (port < 1024 || port > 65535) {
            throw new InvalidSelendroidPortException("You have to specify port between 1024 and 65535, you entered: " + port);
        }
    }
}

