/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.platform.impl;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.platform.event.DroidiumPlatformConfigured;
import org.arquillian.droidium.platform.impl.DroidiumPlatformConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DroidiumPlatformConfigurator {
    private static final Logger logger = Logger.getLogger(DroidiumPlatformConfigurator.class.getName());
    private static final String DROIDIUM_PLATFORM_EXTENSION_NAME = "droidium-platform";
    @Inject
    @ApplicationScoped
    private InstanceProducer<DroidiumPlatformConfiguration> configuration;
    @Inject
    private Event<DroidiumPlatformConfigured> platformConfigured;

    public void configureDroidiumPlatofrm(@Observes ArquillianDescriptor descriptor) {
        logger.info("Configuring droidium-platform");
        DroidiumPlatformConfiguration configuration = new DroidiumPlatformConfiguration();
        for (ExtensionDef extensionDef : descriptor.getExtensions()) {
            if (!DROIDIUM_PLATFORM_EXTENSION_NAME.equals(extensionDef.getExtensionName())) continue;
            Map properties = extensionDef.getExtensionProperties();
            configuration.setProperties(properties);
            break;
        }
        configuration.validate();
        if (logger.isLoggable(Level.INFO)) {
            System.out.println("Configuration of Arquillian Droidium Platform");
            System.out.println(configuration);
        }
        this.configuration.set((Object)configuration);
        this.platformConfigured.fire((Object)new DroidiumPlatformConfigured());
    }
}

