/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.web.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.droidium.container.configuration.Validate;

public class DroidiumWebConfiguration {
    private String serverApk = "android-server.apk";
    private String logFile = "target" + System.getProperty("file.separator") + "android.log";
    private String options = "";
    private String debug = "false";
    private Map<String, String> properties = new HashMap<String, String>();

    public File getServerApk() {
        return new File(this.getProperty("serverApk", this.serverApk));
    }

    public File getLogFile() {
        return new File(this.getProperty("logFile", this.logFile));
    }

    public String getOptions() {
        return new String(this.getProperty("options", this.options));
    }

    public boolean getDebug() {
        return Boolean.parseBoolean(this.getProperty("debug", this.debug));
    }

    public void setProperties(Map<String, String> properties) {
        Validate.notNull(properties, (String)"Properties to set for Arquillian Droidium web configuration can not be a null object.");
        this.properties = properties;
    }

    public String getProperty(String name, String defaultValue) {
        Validate.notNullOrEmpty((String)name, (String)"unable to get configuration value of null configuration key");
        Validate.notNull((Object)defaultValue, (String)("unable to set configuration value of " + name + " to null"));
        String found = this.properties.get(name);
        if (found == null || found.length() == 0) {
            return defaultValue;
        }
        return found;
    }

    public void setProperty(String property, String value) {
        Validate.notNullOrEmpty((String)property, (String)"unable to set configuration value which key is null");
        Validate.notNull((Object)value, (String)"unable to set configuration value which is null");
        this.properties.put(property, value);
    }

    public void validate() {
        Validate.isReadable((File)this.getServerApk(), (String)("You must provide a valid path to Android Server APK for Arquillian Droidium web plugin. Plese be sure you have read access to the file you have specified: " + this.getServerApk()));
        try {
            this.getLogFile().createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create logging file for Arquillian Droidium web plugin at" + this.getLogFile().getAbsolutePath() + ".", e);
        }
    }
}

