/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.web.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.web.spi.event.AndroidServerUninstalled;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidServerUninstaller {
    private static final Logger log = Logger.getLogger(AndroidServerUninstaller.class.getName());
    private static final String APK_APP_NAME = "org.openqa.selenium.android.app";
    @Inject
    private Event<AndroidServerUninstalled> androidServerUninstalled;

    public void uninstall(@Observes(precedence=10) AndroidContainerStop event, AndroidDevice device) {
        Validate.notNull((Object)device, (String)"Injected Android device for is null!");
        try {
            device.uninstallPackage(APK_APP_NAME);
            log.info("Uninstallation of Android server for Arquillian Droidium web was performed.");
        }
        catch (AndroidExecutionException ex) {
            log.info("Uninstallation of Android server for Arquillian Droidium web failed.");
        }
        try {
            log.log(Level.INFO, "Removing port forwaring from {0} to {1} for Android server of Arquillian Droidium web support.", new Object[]{device.getDroneHostPort(), device.getDroneGuestPort()});
            device.removePortForwarding(device.getDroneHostPort(), device.getDroneGuestPort());
            log.info("Removing of port forwarding for Arquillian Droidium web support was successful. ");
        }
        catch (AndroidExecutionException ex) {
            log.info("Removing of port forwarding for Arquillian Droidium Web support after Android server was uninstalled failed.");
        }
        this.androidServerUninstalled.fire((Object)new AndroidServerUninstalled());
    }
}

