/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.web.configuration;

import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.droidium.web.configuration.DroidiumWebConfiguration;
import org.arquillian.droidium.web.spi.event.DroidiumWebConfigured;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class DroidiumWebConfigurator {
    private static final Logger logger = Logger.getLogger(DroidiumWebConfigurator.class.getName());
    public static final String DROIDIUM_WEB_EXTENSION_NAME = "droidium-web";
    @Inject
    @SuiteScoped
    private InstanceProducer<DroidiumWebConfiguration> droidiumWebConfiguration;
    @Inject
    private Event<DroidiumWebConfigured> droidiumWebConfigured;

    public void configureDroidiumWeb(@Observes(precedence=10) BeforeSuite event, ArquillianDescriptor descriptor) {
        logger.info("Configuring droidium-web");
        DroidiumWebConfiguration configuration = new DroidiumWebConfiguration();
        for (ExtensionDef extensionDef : descriptor.getExtensions()) {
            if (!DROIDIUM_WEB_EXTENSION_NAME.equals(extensionDef.getExtensionName())) continue;
            Map properties = extensionDef.getExtensionProperties();
            configuration.setProperties(properties);
            configuration.validate();
        }
        this.droidiumWebConfiguration.set((Object)configuration);
        this.droidiumWebConfigured.fire((Object)new DroidiumWebConfigured());
    }
}

