/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.web.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.web.configuration.DroidiumWebConfiguration;
import org.arquillian.droidium.web.spi.event.AndroidServerInstalled;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidServerInstaller {
    private static final Logger log = Logger.getLogger(AndroidServerInstaller.class.getName());
    private static final String APK_APP_NAME = "org.openqa.selenium.android.app";
    @Inject
    private Event<AndroidServerInstalled> androidServerInstalled;
    @Inject
    private Instance<DroidiumWebConfiguration> configuration;

    public void install(@Observes AndroidDeviceReady event) throws AndroidExecutionException, IOException {
        AndroidDevice device = event.getDevice();
        this.installServerAPK(device, ((DroidiumWebConfiguration)this.configuration.get()).getServerApk());
        log.info("Installation of Android Server APK for Arquillan Droidium web support was performed.");
        log.info("Starting Android Server for Arquillian Droidium web testing.");
        WebDriverMonkey monkey = new WebDriverMonkey(((DroidiumWebConfiguration)this.configuration.get()).getLogFile());
        device.executeShellCommand(this.getWebDriverHubCommand().toString(), (AndroidDeviceOutputReciever)monkey);
        log.info("Waiting until Android server for Arquillian Droidium web support is started.");
        this.waitUntilStarted(device, monkey);
        log.log(Level.INFO, "Creating port forwarding from {0} to {1} from Android server to Arquillian Droidium web plugin.", new Object[]{device.getDroneHostPort(), device.getDroneGuestPort()});
        device.createPortForwarding(device.getDroneHostPort(), device.getDroneGuestPort());
        this.androidServerInstalled.fire((Object)new AndroidServerInstalled());
    }

    private void installServerAPK(AndroidDevice device, File apk) throws AndroidExecutionException {
        if (device.isPackageInstalled(APK_APP_NAME)) {
            log.info("Package org.openqa.selenium.android.app is installed, trying to uninstall it.");
            device.uninstallPackage(APK_APP_NAME);
        }
        device.installPackage(apk, true, new String[0]);
    }

    private Command getTopCommand() {
        Command command = new Command();
        command.add("top -n 1");
        return command;
    }

    private Command getWebDriverHubCommand() {
        Command command = new Command();
        command.add("am start -a android.intent.action.MAIN -n org.openqa.selenium.android.app/.MainActivity");
        command.add(((DroidiumWebConfiguration)this.configuration.get()).getOptions());
        if (!command.toString().contains("-e debug") && ((DroidiumWebConfiguration)this.configuration.get()).getDebug()) {
            command.add("-e debug true");
        }
        return command;
    }

    private void waitUntilStarted(AndroidDevice device, WebDriverMonkey monkey) throws IOException, AndroidExecutionException {
        log.info("Starting Web Driver Hub on Android device.");
        for (int i = 0; i < 5; ++i) {
            device.executeShellCommand(this.getTopCommand().toString(), (AndroidDeviceOutputReciever)monkey);
            if (monkey.isWebDriverHubStarted()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        throw new AndroidExecutionException("Unable to start Android Server for Arquillian Droidium web support.");
    }

    private static class WebDriverMonkey
    implements AndroidDeviceOutputReciever {
        private static final Logger logger = Logger.getLogger(WebDriverMonkey.class.getName());
        private final Writer output;
        private boolean started = false;

        public WebDriverMonkey(File output) throws IOException {
            this.output = new FileWriter(output);
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                logger.finest(line);
                try {
                    this.output.append(line).append("\n").flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!line.contains(AndroidServerInstaller.APK_APP_NAME)) continue;
                this.started = true;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isWebDriverHubStarted() {
            return this.started;
        }
    }
}

