/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.configuration;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.extension.governor.api.GovernorConfigurationException;
import org.arquillian.extension.governor.configuration.GovernorConfiguration;
import org.arquillian.extension.governor.spi.event.GovernorExtensionConfigured;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class GovernorConfigurator {
    private static final Logger logger = Logger.getLogger(GovernorConfigurator.class.getName());
    private static final String EXTENSION_NAME = "governor";
    @Inject
    @ApplicationScoped
    private InstanceProducer<GovernorConfiguration> governorConfiguration;
    @Inject
    private Event<GovernorExtensionConfigured> governorExtensionConfiguredEvent;

    public void onArquillianDescriptor(@Observes ArquillianDescriptor arquillianDescriptor) throws GovernorConfigurationException {
        GovernorConfiguration governorConfiguration = new GovernorConfiguration();
        for (ExtensionDef extension : arquillianDescriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(EXTENSION_NAME)) continue;
            governorConfiguration.setConfiguration(extension.getExtensionProperties());
            governorConfiguration.validate();
            break;
        }
        this.governorConfiguration.set((Object)governorConfiguration);
        if (logger.isLoggable(Level.INFO)) {
            System.out.println("Configuration of Arquillian Governor extension: ");
            System.out.println(governorConfiguration.toString());
        }
        this.governorExtensionConfiguredEvent.fire((Object)new GovernorExtensionConfigured());
    }
}

