/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arquillian.extension.governor.api.Governor;
import org.arquillian.extension.governor.api.GovernorRegistry;
import org.arquillian.extension.governor.configuration.GovernorConfiguration;
import org.arquillian.extension.governor.impl.GovernorRegistryImpl;
import org.arquillian.extension.governor.impl.TestMethodExecutionRegister;
import org.arquillian.extension.governor.spi.GovernorProvider;
import org.arquillian.extension.governor.spi.event.DecideMethodExecutions;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class GovernorTestClassScanner {
    @Inject
    @ApplicationScoped
    private InstanceProducer<GovernorRegistry> governorRegistry;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<DecideMethodExecutions> decideMethodExecution;
    @Inject
    private Instance<GovernorConfiguration> governorConfiguration;

    public void onBeforeClass(@Observes BeforeClass event) {
        TestMethodExecutionRegister.setConfigration((GovernorConfiguration)((Object)this.governorConfiguration.get()));
        TestMethodExecutionRegister.clear();
        if (((GovernorConfiguration)((Object)this.governorConfiguration.get())).getIgnore().booleanValue()) {
            return;
        }
        Collection governorProviders = ((ServiceLoader)this.serviceLoader.get()).all(GovernorProvider.class);
        this.checkGovernorProviderUniqueness(governorProviders);
        Map<Method, List<Annotation>> scannedTestMethods = this.scanTestMethods(event.getTestClass(), Governor.class);
        GovernorRegistryImpl governorRegistry = new GovernorRegistryImpl();
        governorRegistry.put(scannedTestMethods);
        this.governorRegistry.set((Object)governorRegistry);
        this.decideMethodExecution.fire((Object)new DecideMethodExecutions());
    }

    private void checkGovernorProviderUniqueness(Collection<GovernorProvider> governorProviders) {
        HashSet<Class> uniqueProviders = new HashSet<Class>();
        for (GovernorProvider governorProvider : governorProviders) {
            Class governorClass = governorProvider.provides();
            if (governorClass == null) {
                throw new IllegalStateException(String.format("Governor provider's provides() method (%s) returns null object.", governorProvider.getClass().getName()));
            }
            Governor governorAnnotation = governorClass.getAnnotation(Governor.class);
            if (governorAnnotation == null) {
                throw new IllegalStateException(String.format("Governor provider (%s) does not provide annotation annotated by Governor class.", governorProvider.getClass().getName()));
            }
            if (uniqueProviders.add(governorClass)) continue;
            throw new IllegalStateException(String.format("You have put on class path providers which provide the same governor annotation (%s).", governorAnnotation.annotationType()));
        }
    }

    private Map<Method, List<Annotation>> scanTestMethods(TestClass testClass, Class<? extends Annotation> governorAnnotation) {
        Method[] methods;
        Validate.notNull((Object)testClass, (String)"Test class to scan must be specified.");
        HashMap<Method, List<Annotation>> methodAnnotationsMap = new HashMap<Method, List<Annotation>>();
        for (Method method : methods = testClass.getJavaClass().getMethods()) {
            ArrayList<Annotation> methodAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(governorAnnotation)) continue;
                methodAnnotations.add(annotation);
            }
            if (methodAnnotations.size() <= 0) continue;
            methodAnnotationsMap.put(method, methodAnnotations);
        }
        return methodAnnotationsMap;
    }
}

