/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.extension.governor.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.arquillian.extension.governor.configuration.GovernorConfiguration;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;

public final class TestMethodExecutionRegister {
    private static final List<MethodExecutionDecision> methodExecutionDecisions = new ArrayList<MethodExecutionDecision>();
    private static GovernorConfiguration governorConfiguration;
    private static ExecutionDecision DEFAULT_EXECUTION_DECISION;

    public static void clear() {
        methodExecutionDecisions.clear();
    }

    public static void put(String testMethod, Class<? extends Annotation> annotation, ExecutionDecision executionDecision) {
        MethodExecutionDecision methodExecutionDecision = new MethodExecutionDecision(testMethod, annotation, executionDecision);
        methodExecutionDecisions.add(methodExecutionDecision);
    }

    public static List<MethodExecutionDecision> getAll() {
        return Collections.unmodifiableList(methodExecutionDecisions);
    }

    public static ExecutionDecision resolve(Method testMethod, Class<? extends Annotation> annotation) {
        String annotationName = annotation.getName();
        if (annotationName.equals(governorConfiguration.getIgnoreOnly())) {
            return DEFAULT_EXECUTION_DECISION;
        }
        for (MethodExecutionDecision methodExecutionDecision : methodExecutionDecisions) {
            if (!methodExecutionDecision.getTestMethod().equals(testMethod.toString()) || methodExecutionDecision.getAnnotation() != annotation) continue;
            return methodExecutionDecision.getExecutionDecision();
        }
        return DEFAULT_EXECUTION_DECISION;
    }

    public static void setConfigration(GovernorConfiguration governorConfiguration) {
        Validate.notNull((Object)((Object)governorConfiguration), (String)"GovernorConfiguration must be specified.");
        TestMethodExecutionRegister.governorConfiguration = governorConfiguration;
    }

    static {
        DEFAULT_EXECUTION_DECISION = ExecutionDecision.execute((String)"default execution");
    }

    public static final class MethodExecutionDecision {
        private final String testMethod;
        private final Class<? extends Annotation> annotation;
        private final ExecutionDecision executionDecision;

        public MethodExecutionDecision(String testMethod, Class<? extends Annotation> annotation, ExecutionDecision executionDecision) {
            Validate.notNull((Object)testMethod, (String)"Test method has to be specified.");
            Validate.notNull(annotation, (String)"Annotation has to be specified.");
            Validate.notNull((Object)executionDecision, (String)"Execution decision has to be specified.");
            this.testMethod = testMethod;
            this.annotation = annotation;
            this.executionDecision = executionDecision;
        }

        public String getTestMethod() {
            return this.testMethod;
        }

        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        public ExecutionDecision getExecutionDecision() {
            return this.executionDecision;
        }
    }
}

