/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.arquillian.pact.git.PassphraseUserInfo;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitOperations {
    public boolean isValidGitRepository(Path folder) {
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            return RepositoryCache.FileKey.isGitRepository((File)folder.toFile(), (FS)FS.DETECTED);
        }
        return false;
    }

    public Git openGitRepository(Path path) throws IOException {
        return Git.open((File)path.toFile());
    }

    public Ref checkoutTag(Git git, String tag) {
        try {
            return git.checkout().setName("tags/" + tag).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isLocalBranch(Git git, String branch) {
        try {
            List refs = git.branchList().call();
            return refs.stream().anyMatch(ref -> ref.getName().endsWith(branch));
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isRemoteBranch(Git git, String branch, String remote) {
        try {
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            String remoteBranch = remote + "/" + branch;
            return refs.stream().anyMatch(ref -> ref.getName().endsWith(remoteBranch));
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Ref checkoutBranch(Git git, String branch) {
        try {
            return git.checkout().setName(branch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Ref checkoutBranch(Git git, String branch, String remote) {
        try {
            return git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(remote + "/" + branch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Ref createBranchAndCheckout(Git git, String branch) {
        try {
            return git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public RevCommit addAndCommit(Git git, String message) {
        try {
            git.add().addFilepattern(".").call();
            return git.commit().setMessage(message).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public RevCommit addAndCommit(Git git, String message, String author, String email) {
        try {
            git.add().addFilepattern(".").call();
            return git.commit().setAuthor(author, email).setMessage(message).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public PullResult pullFromRepository(Git git, String remote, String remoteBranch) {
        try {
            return git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<PushResult> pushToRepository(Git git, String remote) {
        try {
            return git.push().setRemote(remote).setPushAll().setPushTags().call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<PushResult> pushToRepository(Git git, String remote, String username, String password) {
        try {
            return ((PushCommand)git.push().setRemote(remote).setPushAll().setPushTags().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Ref createTag(Git git, String name) {
        try {
            return git.tag().setName(name).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<PushResult> pushToRepository(Git git, String remote, final String passphrase, final Path privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setUserInfo((UserInfo)new PassphraseUserInfo(passphrase));
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                if (privateKey != null) {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(privateKey.toFile().getAbsolutePath());
                    return defaultJSch;
                }
                return super.createDefaultJSch(fs);
            }
        };
        try {
            return ((PushCommand)git.push().setRemote(remote).setPushAll().setPushTags().setTransportConfigCallback(arg_0 -> GitOperations.lambda$pushToRepository$2((SshSessionFactory)sshSessionFactory, arg_0))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public PullResult pullFromRepository(Git git, String remote, String remoteBranch, String username, String password) {
        try {
            return ((PullCommand)git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public PullResult pullFromRepository(Git git, String remote, String remoteBranch, final String passphrase, final Path privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setUserInfo((UserInfo)new PassphraseUserInfo(passphrase));
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                if (privateKey != null) {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(privateKey.toFile().getAbsolutePath());
                    return defaultJSch;
                }
                return super.createDefaultJSch(fs);
            }
        };
        try {
            return ((PullCommand)git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).setTransportConfigCallback(arg_0 -> GitOperations.lambda$pullFromRepository$3((SshSessionFactory)sshSessionFactory, arg_0))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath) {
        try {
            return Git.cloneRepository().setURI(remoteUrl).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath, String username, String password) {
        try {
            return ((CloneCommand)Git.cloneRepository().setURI(remoteUrl).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath, final String passphrase, final Path privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setUserInfo((UserInfo)new PassphraseUserInfo(passphrase));
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                if (privateKey != null) {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(privateKey.toFile().getAbsolutePath());
                    return defaultJSch;
                }
                return super.createDefaultJSch(fs);
            }
        };
        try {
            return ((CloneCommand)Git.cloneRepository().setURI(remoteUrl).setTransportConfigCallback(arg_0 -> GitOperations.lambda$cloneRepository$4((SshSessionFactory)sshSessionFactory, arg_0))).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean hasAtLeastOneReference(Repository repo) {
        for (Ref ref : repo.getAllRefs().values()) {
            if (ref.getObjectId() == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$cloneRepository$4(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }

    private static /* synthetic */ void lambda$pullFromRepository$3(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }

    private static /* synthetic */ void lambda$pushToRepository$2(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }
}

