/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.provider.loader.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.arquillian.pact.provider.loader.git.PassphraseUserInfo;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitOperations {
    public boolean isValidGitRepository(Path folder) {
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            return RepositoryCache.FileKey.isGitRepository((File)folder.toFile(), (FS)FS.DETECTED);
        }
        return false;
    }

    public Git openGitRepository(Path path) throws IOException {
        return Git.open((File)path.toFile());
    }

    public Ref checkoutTag(Git git, String tag) {
        try {
            return git.checkout().setName("tags/" + tag).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isLocalBranch(Git git, String branch) {
        try {
            List refs = git.branchList().call();
            for (Ref ref : refs) {
                if (!ref.getName().endsWith(branch)) continue;
                return true;
            }
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
        return false;
    }

    public Ref checkoutBranch(Git git, String branch) {
        try {
            return git.checkout().setName(branch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Ref checkoutBranch(Git git, String branch, String remote) {
        try {
            return git.checkout().setCreateBranch(true).setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(remote + "/" + branch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PullResult pullRepository(Git git, String remote, String remoteBranch) {
        try {
            return git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PullResult pullRepository(Git git, String remote, String remoteBranch, String username, String password) {
        try {
            return ((PullCommand)git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PullResult pullRepository(Git git, String remote, String remoteBranch, final String passphrase, final Path privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setUserInfo((UserInfo)new PassphraseUserInfo(passphrase));
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                if (privateKey != null) {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(privateKey.toFile().getAbsolutePath());
                    return defaultJSch;
                }
                return super.createDefaultJSch(fs);
            }
        };
        try {
            return ((PullCommand)git.pull().setRemote(remote).setRemoteBranchName(remoteBranch).setTransportConfigCallback(arg_0 -> GitOperations.lambda$pullRepository$0((SshSessionFactory)sshSessionFactory, arg_0))).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath) {
        try {
            return Git.cloneRepository().setURI(remoteUrl).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath, String username, String password) {
        try {
            return ((CloneCommand)Git.cloneRepository().setURI(remoteUrl).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Git cloneRepository(String remoteUrl, Path localPath, final String passphrase, final Path privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setUserInfo((UserInfo)new PassphraseUserInfo(passphrase));
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                if (privateKey != null) {
                    JSch defaultJSch = super.createDefaultJSch(fs);
                    defaultJSch.addIdentity(privateKey.toFile().getAbsolutePath());
                    return defaultJSch;
                }
                return super.createDefaultJSch(fs);
            }
        };
        try {
            return ((CloneCommand)Git.cloneRepository().setURI(remoteUrl).setTransportConfigCallback(arg_0 -> GitOperations.lambda$cloneRepository$1((SshSessionFactory)sshSessionFactory, arg_0))).setDirectory(localPath.toFile()).call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean hasAtLeastOneReference(Repository repo) {
        for (Ref ref : repo.getAllRefs().values()) {
            if (ref.getObjectId() == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$cloneRepository$1(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }

    private static /* synthetic */ void lambda$pullRepository$0(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }
}

