/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.provider.loader.git;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.arquillian.pact.configuration.HomeResolver;
import org.arquillian.pact.configuration.PactRunnerExpressionParser;
import org.arquillian.pact.git.GitOperations;
import org.arquillian.pact.provider.loader.git.PactGit;
import org.arquillian.pact.provider.spi.loader.PactLoader;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;

public class PactGitLoader
implements PactLoader {
    private static final Logger logger = Logger.getLogger(PactGitLoader.class.getName());
    private PactGit pactGit;
    GitOperations gitOperations;

    public PactGitLoader(PactGit pactGit) {
        this.pactGit = pactGit;
        this.gitOperations = new GitOperations();
    }

    public List<Pact> load(String providerName) throws IOException {
        File[] files;
        Path location = this.getPactsFolderFromGitRepo();
        if (location != null && (files = location.toFile().listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            return Arrays.stream(files).map(PactReader::loadPact).filter(pact -> pact.getProvider().getName().equals(providerName)).collect(Collectors.toList());
        }
        return new ArrayList<Pact>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Path getPactsFolderFromGitRepo() throws IOException {
        Path location = null;
        try (Git git = null;){
            if (this.isSet(this.pactGit.repository())) {
                Path repository = Paths.get(this.getResolvedValue(this.pactGit.repository()), new String[0]);
                if (this.gitOperations.isValidGitRepository(repository)) {
                    git = this.gitOperations.openGitRepository(repository);
                    if (!this.gitOperations.hasAtLeastOneReference(git.getRepository())) throw new IllegalArgumentException(String.format("Git repository %s was not cloned correctly.", git.getRepository().getDirectory().getAbsolutePath()));
                    PullResult pullResult = this.executePull(git);
                    if (!pullResult.isSuccessful()) throw new IllegalArgumentException("There are merge conflicts into an existing git repo. Provider should not deal with merge conflicts. Correct them or delete the repo and execute again the test.");
                    location = this.moveToCorrectLocation(git);
                    return location;
                } else {
                    logger.log(Level.INFO, String.format("%s directory is not a git directory or does not exists and it is going to be deleted and cloned", repository));
                    Files.deleteIfExists(repository);
                    Files.createDirectories(repository, new FileAttribute[0]);
                    git = this.executeClone(repository);
                    location = this.moveToCorrectLocation(git);
                }
                return location;
            } else {
                Path testGitRepository = Files.createTempDirectory("TestGitRepository", new FileAttribute[0]);
                logger.log(Level.INFO, String.format("Repository is going to be cloned at %s", testGitRepository));
                git = this.executeClone(testGitRepository);
                location = this.moveToCorrectLocation(git);
            }
            return location;
        }
    }

    private Path moveToCorrectLocation(Git git) {
        File directory = git.getRepository().getDirectory().getParentFile();
        if (this.isSet(this.pactGit.tag())) {
            this.gitOperations.checkoutTag(git, this.getResolvedValue(this.pactGit.tag()));
        } else {
            String branch = this.getResolvedValue(this.pactGit.branch());
            if (this.gitOperations.isLocalBranch(git, branch)) {
                this.gitOperations.checkoutBranch(git, branch);
            } else {
                this.gitOperations.checkoutBranch(git, branch, this.getResolvedValue(this.pactGit.remote()));
            }
        }
        if (this.isSet(this.pactGit.pactDirectory())) {
            return Paths.get(directory.getAbsolutePath(), this.getResolvedValue(this.pactGit.pactDirectory()));
        }
        return Paths.get(directory.getAbsolutePath(), new String[0]);
    }

    private Git executeClone(Path repository) {
        Git git = this.isSet(this.pactGit.username()) && this.isSet(this.pactGit.password()) ? this.gitOperations.cloneRepository(this.getResolvedValue(this.pactGit.value()), repository, this.getResolvedValue(this.pactGit.username()), this.getResolvedValue(this.pactGit.password())) : (this.isSet(this.pactGit.passphrase()) ? this.gitOperations.cloneRepository(this.getResolvedValue(this.pactGit.value()), repository, this.getResolvedValue(this.pactGit.passphrase()), this.getPrivateKey()) : this.gitOperations.cloneRepository(this.getResolvedValue(this.pactGit.value()), repository));
        return git;
    }

    private PullResult executePull(Git git) {
        PullResult pullResult = this.isSet(this.pactGit.username()) && this.isSet(this.pactGit.password()) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.pactGit.remote()), this.getResolvedValue(this.pactGit.branch()), this.getResolvedValue(this.pactGit.username()), this.getResolvedValue(this.pactGit.password())) : (this.isSet(this.pactGit.passphrase()) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.pactGit.remote()), this.getResolvedValue(this.pactGit.branch()), this.getResolvedValue(this.pactGit.passphrase()), this.getPrivateKey()) : this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.pactGit.remote()), this.getResolvedValue(this.pactGit.branch())));
        return pullResult;
    }

    private Path getPrivateKey() {
        if (this.isSet(this.pactGit.key())) {
            return Paths.get(this.getResolvedValue(HomeResolver.resolveHomeDirectory((String)this.pactGit.key())), new String[0]);
        }
        return null;
    }

    private boolean isSet(String field) {
        return !"".equals(field);
    }

    private String getResolvedValue(String field) {
        return PactRunnerExpressionParser.parseExpressions((String)field);
    }
}

