/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantObject;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.FieldGenOrMethodGen;
import org.aspectj.apache.bcel.generic.Type;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;

    public FieldGen(int n, Type type, String string, ConstantPool constantPool) {
        this.setModifiers(n);
        this.setType(type);
        this.setName(string);
        this.setConstantPool(constantPool);
    }

    public FieldGen(Field field, ConstantPool constantPool) {
        this(field.getModifiers(), Type.getType(field.getSignature()), field.getName(), constantPool);
        Attribute[] attributeArray = field.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] instanceof ConstantValue) {
                this.setValue(((ConstantValue)attributeArray[i]).getConstantValueIndex());
                continue;
            }
            if (attributeArray[i] instanceof RuntimeAnnos) {
                RuntimeAnnos runtimeAnnos = (RuntimeAnnos)attributeArray[i];
                List<AnnotationGen> list = runtimeAnnos.getAnnotations();
                for (AnnotationGen annotationGen : list) {
                    this.addAnnotation(new AnnotationGen(annotationGen, constantPool, false));
                }
                continue;
            }
            this.addAttribute(attributeArray[i]);
        }
    }

    public void setValue(int n) {
        ConstantPool constantPool = this.cp;
        Constant constant = constantPool.getConstant(n);
        this.value = constant instanceof ConstantInteger ? Integer.valueOf(((ConstantInteger)constant).getIntValue()) : (constant instanceof ConstantFloat ? ((ConstantFloat)constant).getValue() : (constant instanceof ConstantDouble ? ((ConstantDouble)constant).getValue() : (constant instanceof ConstantLong ? ((ConstantLong)constant).getValue() : (constant instanceof ConstantString ? ((ConstantString)constant).getString(constantPool) : ((ConstantObject)((Object)constant)).getConstantValue(constantPool)))));
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void wipeValue() {
        this.value = null;
    }

    private void checkType(Type type) {
        if (this.type == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!this.type.equals(type)) {
            throw new ClassGenException("Types are not compatible: " + this.type + " vs. " + type);
        }
    }

    public Field getField() {
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        if (this.value != null) {
            this.checkType(this.type);
            int n3 = this.addConstant();
            this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, n3, this.cp));
        }
        this.addAnnotationsAsAttribute(this.cp);
        return new Field(this.modifiers, n, n2, this.getAttributesImmutable(), this.cp);
    }

    private int addConstant() {
        switch (this.type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return this.cp.addInteger((Integer)this.value);
            }
            case 6: {
                return this.cp.addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return this.cp.addDouble((Double)this.value);
            }
            case 11: {
                return this.cp.addLong((Long)this.value);
            }
            case 14: {
                return this.cp.addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + this.type.getType());
    }

    @Override
    public String getSignature() {
        return this.type.getSignature();
    }

    public String getInitialValue() {
        return this.value == null ? null : this.value.toString();
    }

    public void setInitialStringValue(String string) {
        this.value = string;
    }

    public final String toString() {
        String string = Utility.accessToString(this.modifiers);
        string = string.equals("") ? "" : string + " ";
        String string2 = this.type.toString();
        String string3 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string).append(string2).append(" ").append(string3);
        String string4 = this.getInitialValue();
        if (string4 != null) {
            stringBuffer.append(" = ").append(string4);
        }
        return stringBuffer.toString();
    }
}

