/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.ReturnaddressType;
import org.aspectj.apache.bcel.generic.Type;

public class InstructionBranch
extends Instruction
implements InstructionTargeter {
    private static final int UNSET = -1;
    protected int targetIndex = -1;
    protected InstructionHandle targetInstruction;
    protected int positionOfThisInstruction;

    public InstructionBranch(short s, InstructionHandle instructionHandle) {
        super(s);
        this.setTarget(instructionHandle);
    }

    public InstructionBranch(short s, int n) {
        super(s);
        this.targetIndex = n;
    }

    public InstructionBranch(short s) {
        super(s);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n = this.getTargetOffset();
        if (Math.abs(n) >= Short.MAX_VALUE && this.opcode != 200 && this.opcode != 201) {
            throw new ClassGenException("Branch target offset too large for short.  Instruction: " + this.getName().toUpperCase() + "(" + this.opcode + ")");
        }
        dataOutputStream.writeByte(this.opcode);
        switch (this.opcode) {
            case 200: 
            case 201: {
                dataOutputStream.writeInt(n);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                dataOutputStream.writeShort(n);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to write out " + this.getName().toUpperCase());
            }
        }
    }

    protected int getTargetOffset() {
        if (this.targetInstruction == null && this.targetIndex == -1) {
            throw new ClassGenException("Target of " + super.toString(true) + " is unknown");
        }
        if (this.targetInstruction == null) {
            return this.targetIndex;
        }
        return this.targetInstruction.getPosition() - this.positionOfThisInstruction;
    }

    protected int updatePosition(int n, int n2) {
        int n3 = this.getTargetOffset();
        this.positionOfThisInstruction += n;
        if (Math.abs(n3) >= Short.MAX_VALUE - n2 && this.opcode != 201 && this.opcode != 200) {
            if (this.opcode == 168 || this.opcode == 167) {
                this.opcode = this.opcode == 168 ? (short)201 : (short)200;
                return 2;
            }
            throw new IllegalStateException("Unable to pack method, jump (with opcode=" + this.opcode + ") is too far: " + Math.abs(n3));
        }
        return 0;
    }

    @Override
    public String toString(boolean bl) {
        String string = super.toString(bl);
        String string2 = "null";
        if (bl) {
            if (this.targetInstruction != null) {
                string2 = this.targetInstruction.getInstruction() == this ? "<points to itself>" : (this.targetInstruction.getInstruction() == null ? "<null destination>" : this.targetInstruction.getInstruction().toString(false));
            }
        } else if (this.targetInstruction != null) {
            this.targetIndex = this.getTargetOffset();
            string2 = "" + (this.targetIndex + this.positionOfThisInstruction);
        }
        return string + " -> " + string2;
    }

    @Override
    public final int getIndex() {
        return this.targetIndex;
    }

    public InstructionHandle getTarget() {
        return this.targetInstruction;
    }

    public void setTarget(InstructionHandle instructionHandle) {
        InstructionBranch.notifyTarget(this.targetInstruction, instructionHandle, this);
        this.targetInstruction = instructionHandle;
    }

    static final void notifyTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionTargeter instructionTargeter) {
        if (instructionHandle != null) {
            instructionHandle.removeTargeter(instructionTargeter);
        }
        if (instructionHandle2 != null) {
            instructionHandle2.addTargeter(instructionTargeter);
        }
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (this.targetInstruction != instructionHandle) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.targetInstruction);
        }
        this.setTarget(instructionHandle2);
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.targetInstruction == instructionHandle;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.targetIndex = -1;
        this.positionOfThisInstruction = -1;
    }

    @Override
    public Type getType(ConstantPool constantPool) {
        if ((Constants.instFlags[this.opcode] & 0x4000L) != 0L) {
            return new ReturnaddressType(this.physicalSuccessor());
        }
        return super.getType(constantPool);
    }

    public InstructionHandle physicalSuccessor() {
        InstructionHandle instructionHandle = this.targetInstruction;
        while (instructionHandle.getPrev() != null) {
            instructionHandle = instructionHandle.getPrev();
        }
        while (instructionHandle.getInstruction() != this) {
            instructionHandle = instructionHandle.getNext();
        }
        InstructionHandle instructionHandle2 = instructionHandle;
        while (instructionHandle != null) {
            if ((instructionHandle = instructionHandle.getNext()) == null || instructionHandle.getInstruction() != this) continue;
            throw new RuntimeException("physicalSuccessor() called on a shared JsrInstruction.");
        }
        return instructionHandle2.getNext();
    }

    public boolean isIfInstruction() {
        return (Constants.instFlags[this.opcode] & 0x2000L) != 0L;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = this.opcode * 37 + n;
        return n;
    }
}

