/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.sfm.d3.VisOdomDualTrackPnP;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class WrapVisOdomDualTrackPnP<T extends ImageGray<T>>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    @Nullable
    RefinePnPStereo refine;
    Se3_F64 sharedLeftToRight;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceLeft;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceRight;
    PnPStereoDistanceReprojectionSq distanceStereo;
    AssociateStereo2D<?> assoc;
    VisOdomDualTrackPnP<T, ?> visualOdometry;
    Class<T> imageType;
    boolean success;

    public WrapVisOdomDualTrackPnP(VisOdomDualTrackPnP<T, ?> visualOdometry, Se3_F64 sharedLeftToRight, DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceLeft, DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceRight, PnPStereoDistanceReprojectionSq distanceStereo, AssociateStereo2D<?> assoc, @Nullable RefinePnPStereo refine, Class<T> imageType) {
        this.visualOdometry = visualOdometry;
        this.sharedLeftToRight = sharedLeftToRight;
        this.distanceLeft = distanceLeft;
        this.distanceRight = distanceRight;
        this.distanceStereo = distanceStereo;
        this.assoc = assoc;
        this.refine = refine;
        this.imageType = imageType;
    }

    @Override
    public boolean getTrackWorld3D(int index, Point3D_F64 world) {
        VisOdomDualTrackPnP.TrackInfo info = (VisOdomDualTrackPnP.TrackInfo)this.visualOdometry.getVisibleTracks().get(index);
        PerspectiveOps.homogenousTo3dPositiveZ((Point4D_F64)info.worldLoc, (double)1.0E8, (double)1.0E-8, (Point3D_F64)world);
        return true;
    }

    @Override
    public int getTotalTracks() {
        return this.visualOdometry.getVisibleTracks().size();
    }

    @Override
    public long getTrackId(int index) {
        return ((VisOdomDualTrackPnP.TrackInfo)this.visualOdometry.getVisibleTracks().get((int)index)).id;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        PointTrack track = Objects.requireNonNull(((VisOdomDualTrackPnP.TrackInfo)this.visualOdometry.getVisibleTracks().get((int)index)).visualTrack);
        pixel.setTo((GeoTuple2D_F64)track.pixel);
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        throw new RuntimeException("Not supported any more");
    }

    @Override
    public boolean isTrackInlier(int index) {
        VisOdomDualTrackPnP.TrackInfo info = (VisOdomDualTrackPnP.TrackInfo)this.visualOdometry.getVisibleTracks().get(index);
        return info.lastInlier == this.visualOdometry.getFrameID();
    }

    @Override
    public boolean isTrackNew(int index) {
        VisOdomDualTrackPnP.TrackInfo track = (VisOdomDualTrackPnP.TrackInfo)this.visualOdometry.getVisibleTracks().get(index);
        return Objects.requireNonNull(track.visualTrack).spawnFrameID == this.visualOdometry.getFrameID();
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        parameters.getRightToLeft().invert(this.sharedLeftToRight);
        if (this.refine != null) {
            this.refine.setLeftToRight(this.sharedLeftToRight);
        }
        this.visualOdometry.setCalibration(parameters);
        this.distanceLeft.setIntrinsic(0, (CameraPinhole)parameters.left);
        this.distanceRight.setIntrinsic(0, (CameraPinhole)parameters.right);
        this.distanceStereo.setStereoParameters(parameters);
        this.assoc.setCalibration(parameters);
    }

    @Override
    public void reset() {
        this.visualOdometry.reset();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.visualOdometry.getCurrentToWorld();
    }

    @Override
    public long getFrameID() {
        return this.visualOdometry.getFrameID();
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.success = this.visualOdometry.process(leftImage, rightImage);
        return this.success;
    }

    @Override
    public boolean isFault() {
        if (!this.success) {
            return this.visualOdometry.isFault();
        }
        return false;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.visualOdometry.setVerbose(out, configuration);
    }

    public VisOdomDualTrackPnP<T, ?> getAlgorithm() {
        return this.visualOdometry;
    }

    @Nullable
    public RefinePnPStereo getRefine() {
        return this.refine;
    }

    public Se3_F64 getSharedLeftToRight() {
        return this.sharedLeftToRight;
    }

    public DistanceFromModelMultiView<Se3_F64, Point2D3D> getDistanceLeft() {
        return this.distanceLeft;
    }

    public DistanceFromModelMultiView<Se3_F64, Point2D3D> getDistanceRight() {
        return this.distanceRight;
    }

    public PnPStereoDistanceReprojectionSq getDistanceStereo() {
        return this.distanceStereo;
    }

    public AssociateStereo2D<?> getAssoc() {
        return this.assoc;
    }
}

