/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.VariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.MockTaskBuilder;
import org.camunda.bpm.engine.rest.helper.TaskQueryMatcher;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FilterRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    public static final String FILTER_URL = "/rest-test/filter";
    public static final String SINGLE_FILTER_URL = "/rest-test/filter/{id}";
    public static final String CREATE_FILTER_URL = "/rest-test/filter/create";
    public static final String EXECUTE_SINGLE_RESULT_FILTER_URL = "/rest-test/filter/{id}/singleResult";
    public static final String EXECUTE_LIST_FILTER_URL = "/rest-test/filter/{id}/list";
    public static final String EXECUTE_COUNT_FILTER_URL = "/rest-test/filter/{id}/count";
    public static final TaskQuery extendingQuery = new TaskQueryImpl().taskName("aName");
    public static final TaskQueryDto extendingQueryDto = TaskQueryDto.fromQuery((Query)extendingQuery);
    public static final TaskQuery extendingOrQuery = new TaskQueryImpl().or().taskDescription("aDescription").endOr().or().taskName("aName").endOr();
    public static final TaskQueryDto extendingOrQueryDto = TaskQueryDto.fromQuery((Query)extendingOrQuery);
    public static final String invalidExtendingQuery = "abc";
    public static final String PROCESS_INSTANCE_A_ID = "processInstanceA";
    public static final String CASE_INSTANCE_A_ID = "caseInstanceA";
    public static final String EXECUTION_A_ID = "executionA";
    public static final String EXECUTION_B_ID = "executionB";
    public static final String CASE_EXECUTION_A_ID = "caseExecutionA";
    public static final String TASK_A_ID = "taskA";
    public static final String TASK_B_ID = "taskB";
    public static final String TASK_C_ID = "taskC";
    protected FilterService filterServiceMock;
    protected Filter filterMock;
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected VariableInstanceQueryImpl variableInstanceQueryMock;
    protected ProcessEngineConfiguration processEngineConfigurationMock;

    @Before
    public void setUpRuntimeData() {
        this.filterServiceMock = (FilterService)Mockito.mock(FilterService.class);
        Mockito.when((Object)processEngine.getFilterService()).thenReturn((Object)this.filterServiceMock);
        FilterQuery filterQuery = MockProvider.createMockFilterQuery();
        Mockito.when((Object)this.filterServiceMock.createFilterQuery()).thenReturn((Object)filterQuery);
        this.filterMock = MockProvider.createMockFilter();
        Mockito.when((Object)this.filterServiceMock.newTaskFilter()).thenReturn((Object)this.filterMock);
        Mockito.when((Object)this.filterServiceMock.saveFilter((Filter)Matchers.eq((Object)this.filterMock))).thenReturn((Object)this.filterMock);
        Mockito.when((Object)this.filterServiceMock.getFilter((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)this.filterMock);
        Mockito.when((Object)this.filterServiceMock.getFilter((String)Matchers.eq((Object)"nonExistingId"))).thenReturn(null);
        List<TaskEntity> mockTasks = Collections.singletonList(new TaskEntity());
        Mockito.when((Object)this.filterServiceMock.singleResult((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)mockTasks.get(0));
        Mockito.when((Object)this.filterServiceMock.singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn((Object)mockTasks.get(0));
        Mockito.when((Object)this.filterServiceMock.list((String)Matchers.eq((Object)"aFilterId"))).thenReturn(mockTasks);
        Mockito.when((Object)this.filterServiceMock.list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn(mockTasks);
        Mockito.when((Object)this.filterServiceMock.listPage((String)Matchers.eq((Object)"aFilterId"), Matchers.anyInt(), Matchers.anyInt())).thenReturn(mockTasks);
        Mockito.when((Object)this.filterServiceMock.listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class), Matchers.anyInt(), Matchers.anyInt())).thenReturn(mockTasks);
        Mockito.when((Object)this.filterServiceMock.count((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)1L);
        Mockito.when((Object)this.filterServiceMock.count((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn((Object)1L);
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"nonExistingId"));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.any(Query.class));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"nonExistingId"));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.any(Query.class));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).listPage((String)Matchers.eq((Object)"nonExistingId"), Matchers.anyInt(), Matchers.anyInt());
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).listPage((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.any(Query.class), Matchers.anyInt(), Matchers.anyInt());
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).count((String)Matchers.eq((Object)"nonExistingId"));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).count((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.any(Query.class));
        ((FilterService)Mockito.doThrow((Throwable)new NullValueException("No filter found with given id")).when((Object)this.filterServiceMock)).deleteFilter((String)Matchers.eq((Object)"nonExistingId"));
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
        TaskService taskService = processEngine.getTaskService();
        Mockito.when((Object)taskService.createTaskQuery()).thenReturn((Object)new TaskQueryImpl());
        this.variableInstanceQueryMock = (VariableInstanceQueryImpl)Mockito.mock(VariableInstanceQueryImpl.class);
        Mockito.when((Object)processEngine.getRuntimeService().createVariableInstanceQuery()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.variableScopeIdIn(new String[]{(String)Matchers.anyVararg()})).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.variableNameIn(new String[]{(String)Matchers.anyVararg()})).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
    }

    @Test
    public void testGetFilter() {
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.equalTo((Object)"aFilterId"), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).getFilter((String)Matchers.eq((Object)"aFilterId"));
    }

    @Test
    public void testGetNonExistingFilter() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).getFilter((String)Matchers.eq((Object)"nonExistingId"));
    }

    @Test
    public void testGetFilterWithTaskQuery() {
        TaskQueryImpl query = (TaskQueryImpl)Mockito.mock(TaskQueryImpl.class);
        Mockito.when((Object)query.getAssignee()).thenReturn((Object)"anAssignee");
        Mockito.when((Object)query.getAssigneeLike()).thenReturn((Object)"anAssignee");
        Mockito.when((Object)query.getCaseDefinitionId()).thenReturn((Object)"aCaseDefnitionId");
        Mockito.when((Object)query.getCaseDefinitionKey()).thenReturn((Object)"aCaseDefinitionKey");
        Mockito.when((Object)query.getCaseDefinitionName()).thenReturn((Object)"aCaseDefinitionName");
        Mockito.when((Object)query.getCaseDefinitionNameLike()).thenReturn((Object)"aCaseDefinitionNameLike");
        Mockito.when((Object)query.getCaseExecutionId()).thenReturn((Object)"aCaseExecutionId");
        Mockito.when((Object)query.getCaseInstanceBusinessKey()).thenReturn((Object)"aBusinessKey");
        Mockito.when((Object)query.getCaseInstanceBusinessKeyLike()).thenReturn((Object)"aBusinessKeyLike");
        Mockito.when((Object)query.getCaseInstanceId()).thenReturn((Object)"aCaseInstId");
        Mockito.when((Object)query.getCandidateUser()).thenReturn((Object)"userId");
        Mockito.when((Object)query.getCandidateGroup()).thenReturn((Object)"groupId1");
        Mockito.when((Object)query.getProcessInstanceBusinessKey()).thenReturn((Object)"aKey");
        Mockito.when((Object)query.getProcessInstanceBusinessKeyLike()).thenReturn((Object)"aKeyLike");
        Mockito.when((Object)query.getProcessDefinitionKey()).thenReturn((Object)"aKey");
        Mockito.when((Object)query.getProcessDefinitionKeys()).thenReturn((Object)new String[]{"aKey", "aKey"});
        Mockito.when((Object)query.getProcessDefinitionId()).thenReturn((Object)"aProcDefId");
        Mockito.when((Object)query.getExecutionId()).thenReturn((Object)"anExecutionId");
        Mockito.when((Object)query.getProcessDefinitionName()).thenReturn((Object)"aName");
        Mockito.when((Object)query.getProcessDefinitionNameLike()).thenReturn((Object)"aNameLike");
        Mockito.when((Object)query.getProcessInstanceId()).thenReturn((Object)"aProcInstId");
        Mockito.when((Object)query.getKey()).thenReturn((Object)"aTaskDefinitionKey");
        Mockito.when((Object)query.getKeys()).thenReturn((Object)new String[]{"aTaskDefinitionKey", "aTaskDefinitionKey"});
        Mockito.when((Object)query.getKeyLike()).thenReturn((Object)"aTaskDefinitionKey");
        Mockito.when((Object)query.getDescription()).thenReturn((Object)"aDescription");
        Mockito.when((Object)query.getDescriptionLike()).thenReturn((Object)"aDescription");
        Mockito.when((Object)query.getInvolvedUser()).thenReturn((Object)"userId");
        Mockito.when((Object)query.getPriority()).thenReturn((Object)1);
        Mockito.when((Object)query.getMaxPriority()).thenReturn((Object)2);
        Mockito.when((Object)query.getMinPriority()).thenReturn((Object)3);
        Mockito.when((Object)query.getName()).thenReturn((Object)"aName");
        Mockito.when((Object)query.getNameLike()).thenReturn((Object)"aName");
        Mockito.when((Object)query.getOwner()).thenReturn((Object)"anOwner");
        Mockito.when((Object)query.getParentTaskId()).thenReturn((Object)"aParentId");
        Mockito.when((Object)query.getTenantIds()).thenReturn((Object)"aTenantId,anotherTenantId".split(","));
        Mockito.when((Object)query.isTenantIdSet()).thenReturn((Object)true);
        this.filterMock = MockProvider.createMockFilter("aFilterId", query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)this.filterMock);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.assignee", org.hamcrest.Matchers.equalTo((Object)"anAssignee"), new Object[0]).body("query.assigneeLike", org.hamcrest.Matchers.equalTo((Object)"anAssignee"), new Object[0]).body("query.caseDefinitionId", org.hamcrest.Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("query.caseDefinitionKey", org.hamcrest.Matchers.equalTo((Object)"aCaseDefinitionKey"), new Object[0]).body("query.caseDefinitionName", org.hamcrest.Matchers.equalTo((Object)"aCaseDefinitionName"), new Object[0]).body("query.caseDefinitionNameLike", org.hamcrest.Matchers.equalTo((Object)"aCaseDefinitionNameLike"), new Object[0]).body("query.caseExecutionId", org.hamcrest.Matchers.equalTo((Object)"aCaseExecutionId"), new Object[0]).body("query.caseInstanceBusinessKey", org.hamcrest.Matchers.equalTo((Object)"aBusinessKey"), new Object[0]).body("query.caseInstanceBusinessKeyLike", org.hamcrest.Matchers.equalTo((Object)"aBusinessKeyLike"), new Object[0]).body("query.caseInstanceId", org.hamcrest.Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).body("query.candidateUser", org.hamcrest.Matchers.equalTo((Object)"userId"), new Object[0]).body("query.candidateGroup", org.hamcrest.Matchers.equalTo((Object)"groupId1"), new Object[0]).body("query.processInstanceBusinessKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("query.processInstanceBusinessKeyLike", org.hamcrest.Matchers.equalTo((Object)"aKeyLike"), new Object[0]).body("query.processDefinitionKey", org.hamcrest.Matchers.equalTo((Object)"aKey"), new Object[0]).body("query.processDefinitionKeyIn", CoreMatchers.hasItems((Object[])new String[]{"aKey", "aKey"}), new Object[0]).body("query.processDefinitionId", org.hamcrest.Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("query.executionId", org.hamcrest.Matchers.equalTo((Object)"anExecutionId"), new Object[0]).body("query.processDefinitionName", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("query.processDefinitionNameLike", org.hamcrest.Matchers.equalTo((Object)"aNameLike"), new Object[0]).body("query.processInstanceId", org.hamcrest.Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("query.taskDefinitionKey", org.hamcrest.Matchers.equalTo((Object)"aTaskDefinitionKey"), new Object[0]).body("query.taskDefinitionKeyIn", CoreMatchers.hasItems((Object[])new String[]{"aTaskDefinitionKey", "aTaskDefinitionKey"}), new Object[0]).body("query.taskDefinitionKeyLike", org.hamcrest.Matchers.equalTo((Object)"aTaskDefinitionKey"), new Object[0]).body("query.description", org.hamcrest.Matchers.equalTo((Object)"aDescription"), new Object[0]).body("query.descriptionLike", org.hamcrest.Matchers.equalTo((Object)"aDescription"), new Object[0]).body("query.involvedUser", org.hamcrest.Matchers.equalTo((Object)"userId"), new Object[0]).body("query.priority", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).body("query.maxPriority", org.hamcrest.Matchers.equalTo((Object)2), new Object[0]).body("query.minPriority", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).body("query.name", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("query.nameLike", org.hamcrest.Matchers.equalTo((Object)"aName"), new Object[0]).body("query.owner", org.hamcrest.Matchers.equalTo((Object)"anOwner"), new Object[0]).body("query.parentTaskId", org.hamcrest.Matchers.equalTo((Object)"aParentId"), new Object[0]).body("query.tenantIdIn", CoreMatchers.hasItems((Object[])new String[]{"aTenantId", "anotherTenantId"}), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithCandidateGroupQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroup(invalidExtendingQuery);
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.candidateGroup", org.hamcrest.Matchers.equalTo((Object)invalidExtendingQuery), new Object[0]).body("query.containsKey('candidateGroups')", org.hamcrest.Matchers.is((Object)false), new Object[0]).body("query.containsKey('includeAssignedTasks')", org.hamcrest.Matchers.is((Object)false), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithCandidateUserQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(invalidExtendingQuery);
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.candidateUser", org.hamcrest.Matchers.equalTo((Object)invalidExtendingQuery), new Object[0]).body("query.containsKey('candidateGroups')", org.hamcrest.Matchers.is((Object)false), new Object[0]).body("query.containsKey('includeAssignedTasks')", org.hamcrest.Matchers.is((Object)false), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithCandidateIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(invalidExtendingQuery).includeAssignedTasks();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.candidateUser", org.hamcrest.Matchers.equalTo((Object)invalidExtendingQuery), new Object[0]).body("query.containsKey('candidateGroups')", org.hamcrest.Matchers.is((Object)false), new Object[0]).body("query.includeAssignedTasks", org.hamcrest.Matchers.is((Object)true), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithoutTenantIdQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.withoutTenantId();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.withoutTenantId", org.hamcrest.Matchers.is((Object)true), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithoutSorting() {
        TaskQueryImpl query = new TaskQueryImpl();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.sorting", org.hamcrest.Matchers.isEmptyOrNullString(), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testGetFilterWithSingleSorting() {
        TaskQuery query = (TaskQuery)new TaskQueryImpl().orderByTaskName().desc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(1);
        this.assertSorting((Map)sortings.get(0), "name", "desc");
    }

    @Test
    public void testGetFilterWithMultipleSorting() {
        TaskQuery query = (TaskQuery)((TaskQuery)new TaskQueryImpl().orderByDueDate().asc()).orderByCaseExecutionId().desc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(2);
        this.assertSorting((Map)sortings.get(0), "dueDate", "asc");
        this.assertSorting((Map)sortings.get(1), "caseExecutionId", "desc");
    }

    @Test
    public void testGetFilterWithAllPropertiesSorting() {
        TaskQuery query = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)new TaskQueryImpl().orderByProcessInstanceId().asc()).orderByCaseInstanceId().asc()).orderByDueDate().asc()).orderByFollowUpDate().asc()).orderByExecutionId().asc()).orderByCaseExecutionId().asc()).orderByTaskAssignee().asc()).orderByTaskCreateTime().asc()).orderByTaskDescription().asc()).orderByTaskId().asc()).orderByTaskName().asc()).orderByTaskNameCaseInsensitive().asc()).orderByTaskPriority().asc()).orderByTenantId().asc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(14);
        this.assertSorting((Map)sortings.get(0), "instanceId", "asc");
        this.assertSorting((Map)sortings.get(1), "caseInstanceId", "asc");
        this.assertSorting((Map)sortings.get(2), "dueDate", "asc");
        this.assertSorting((Map)sortings.get(3), "followUpDate", "asc");
        this.assertSorting((Map)sortings.get(4), "executionId", "asc");
        this.assertSorting((Map)sortings.get(5), "caseExecutionId", "asc");
        this.assertSorting((Map)sortings.get(6), "assignee", "asc");
        this.assertSorting((Map)sortings.get(7), "created", "asc");
        this.assertSorting((Map)sortings.get(8), "description", "asc");
        this.assertSorting((Map)sortings.get(9), "id", "asc");
        this.assertSorting((Map)sortings.get(10), "name", "asc");
        this.assertSorting((Map)sortings.get(11), "nameCaseInsensitive", "asc");
        this.assertSorting((Map)sortings.get(12), "priority", "asc");
        this.assertSorting((Map)sortings.get(13), "tenantId", "asc");
    }

    @Test
    public void testGetFilterWithVariableTypeSorting() {
        TaskQuery query = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)new TaskQueryImpl().orderByExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByProcessVariable("foo", (ValueType)ValueType.STRING).asc()).orderByTaskVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseInstanceVariable("foo", (ValueType)ValueType.STRING).asc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(5);
        this.assertSorting((Map)sortings.get(0), "executionVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(1), "processVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(2), "taskVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(3), "caseExecutionVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(4), "caseInstanceVariable", "asc", "foo", (ValueType)ValueType.STRING);
    }

    @Test
    public void testGetFilterWithVariableValueTypeSorting() {
        TaskQuery query = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)new TaskQueryImpl().orderByExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.INTEGER).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.SHORT).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.DATE).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.BOOLEAN).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.LONG).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.DOUBLE).asc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(7);
        this.assertSorting((Map)sortings.get(0), "executionVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(1), "executionVariable", "asc", "foo", (ValueType)ValueType.INTEGER);
        this.assertSorting((Map)sortings.get(2), "executionVariable", "asc", "foo", (ValueType)ValueType.SHORT);
        this.assertSorting((Map)sortings.get(3), "executionVariable", "asc", "foo", (ValueType)ValueType.DATE);
        this.assertSorting((Map)sortings.get(4), "executionVariable", "asc", "foo", (ValueType)ValueType.BOOLEAN);
        this.assertSorting((Map)sortings.get(5), "executionVariable", "asc", "foo", (ValueType)ValueType.LONG);
        this.assertSorting((Map)sortings.get(6), "executionVariable", "asc", "foo", (ValueType)ValueType.DOUBLE);
    }

    @Test
    public void testGetFilterWithVariableSortOrderSorting() {
        TaskQuery query = (TaskQuery)((TaskQuery)new TaskQueryImpl().orderByExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.STRING).desc();
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_FILTER_URL, new Object[0]);
        String content = response.asString();
        List sortings = (List)JsonPath.from((String)content).getJsonObject("query.sorting");
        Assertions.assertThat((List)sortings).hasSize(2);
        this.assertSorting((Map)sortings.get(0), "executionVariable", "asc", "foo", (ValueType)ValueType.STRING);
        this.assertSorting((Map)sortings.get(1), "executionVariable", "desc", "foo", (ValueType)ValueType.STRING);
    }

    protected void assertSorting(Map<String, Object> sorting, String sortBy, String sortOrder) {
        this.assertSorting(sorting, sortBy, sortOrder, null, null);
    }

    protected void assertSorting(Map<String, Object> sorting, String sortBy, String sortOrder, String parametersVariable, ValueType parametersType) {
        Assertions.assertThat((Object)sorting.get("sortBy")).isEqualTo((Object)sortBy);
        Assertions.assertThat((Object)sorting.get("sortOrder")).isEqualTo((Object)sortOrder);
        if (parametersVariable == null) {
            Assertions.assertThat((boolean)sorting.containsKey("parameters")).isFalse();
        } else {
            Map parameters = (Map)sorting.get("parameters");
            Assertions.assertThat(parameters.get("variable")).isEqualTo((Object)parametersVariable);
            Assertions.assertThat(parameters.get("type")).isEqualTo((Object)VariableValueDto.toRestApiTypeName((String)parametersType.getName()));
        }
    }

    @Test
    public void testGetFilterWithFollowUpBeforeOrNotExistentExpression() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistentExpression("#{now()}");
        Filter filter = new FilterEntity("Task").setName("test").setQuery((Query)query);
        Mockito.when((Object)this.filterServiceMock.getFilter("aFilterId")).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("query.followUpBeforeOrNotExistentExpression", org.hamcrest.Matchers.equalTo((Object)"#{now()}"), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testCreateFilter() {
        Map<String, Object> json = this.toFilterRequest(MockProvider.createMockFilter());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", org.hamcrest.Matchers.notNullValue(), new Object[0]).when().post(CREATE_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).newTaskFilter();
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).saveFilter((Filter)Matchers.eq((Object)this.filterMock));
    }

    @Test
    public void testCreateInvalidFilter() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(CREATE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testUpdateFilter() {
        Map<String, Object> json = this.toFilterRequest(MockProvider.createMockFilter());
        RestAssured.given().pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).saveFilter((Filter)Matchers.eq((Object)this.filterMock));
    }

    @Test
    public void testInvalidResourceType() {
        Map<String, Object> json = this.toFilterRequest(MockProvider.createMockFilter());
        json.put("resourceType", "invalid");
        RestAssured.given().pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(SINGLE_FILTER_URL, new Object[0]);
    }

    protected Map<String, Object> toFilterRequest(Filter filter) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", filter.getId());
        json.put("name", filter.getName());
        json.put("owner", filter.getOwner());
        json.put("properties", filter.getProperties());
        json.put("resourceType", filter.getResourceType());
        json.put("query", TaskQueryDto.fromQuery((Query)filter.getQuery()));
        return json;
    }

    @Test
    public void testUpdateNonExistingFilter() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().put(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testUpdateInvalidFilter() {
        RestAssured.given().pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testDeleteFilter() {
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).deleteFilter((String)Matchers.eq((Object)"aFilterId"));
    }

    @Test
    public void testDeleteNonExistingFilter() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().delete(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testExecuteSingleResult() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testEmptySingleResult() {
        Mockito.when((Object)this.filterServiceMock.singleResult(Matchers.anyString(), (Query)Matchers.any(Query.class))).thenReturn(null);
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testInvalidSingleResult() {
        ((FilterService)Mockito.doThrow((Throwable)new ProcessEngineException("More than one result found")).when((Object)this.filterServiceMock)).singleResult(Matchers.anyString(), (Query)Matchers.any(Query.class));
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteHalSingleResult() {
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testEmptyHalSingleResult() {
        Mockito.when((Object)this.filterServiceMock.singleResult(Matchers.anyString(), (Query)Matchers.any(Query.class))).thenReturn(null);
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("_links.size()", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).body("_embedded.size()", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testInvalidHalSingleResult() {
        ((FilterService)Mockito.doThrow((Throwable)new ProcessEngineException("More than one result found")).when((Object)this.filterServiceMock)).singleResult(Matchers.anyString(), (Query)Matchers.any(Query.class));
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteSingleResultOfNonExistingFilter() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteSingleResultAsPost() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class));
    }

    @Test
    public void testExecuteHalSingleResultAsPost() {
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class));
    }

    @Test
    public void testExecuteSingleResultInvalidWithExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body(invalidExtendingQuery).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
    }

    @Test
    public void testExecuteSingleResultWithExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body((Object)extendingQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.argThat((Matcher)TaskQueryMatcher.hasName("aName")));
    }

    @Test
    public void testExecuteSingleResultWithExtendingOrQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body((Object)extendingOrQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ArgumentCaptor argument = ArgumentCaptor.forClass(TaskQueryImpl.class);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)argument.capture());
        Assert.assertEquals((Object)"aDescription", (Object)((TaskQueryImpl)((TaskQueryImpl)argument.getValue()).getQueries().get(1)).getDescription());
        Assert.assertEquals((Object)"aName", (Object)((TaskQueryImpl)((TaskQueryImpl)argument.getValue()).getQueries().get(2)).getName());
    }

    @Test
    public void testExecuteList() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testEmptyList() {
        Mockito.when((Object)this.filterServiceMock.list(Matchers.anyString(), (Query)Matchers.any(Query.class))).thenReturn(Collections.emptyList());
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteHalList() {
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testEmptyHalList() {
        Mockito.when((Object)this.filterServiceMock.list(Matchers.anyString(), (Query)Matchers.any(Query.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.filterServiceMock.count(Matchers.anyString(), (Query)Matchers.any(Query.class))).thenReturn((Object)0L);
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("_links.size()", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).body("_embedded.size()", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).body("count", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteListOfNonExistingFilter() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"nonExistingId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteListWithPagination() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").queryParams("firstResult", (Object)1, new Object[0]).queryParams("maxResults", (Object)2, new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class), Matchers.eq((int)1), Matchers.eq((int)2));
    }

    @Test
    public void testExecuteListAsPost() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class));
    }

    @Test
    public void testExecuteHalListAsPost() {
        RestAssured.given().header(ACCEPT_HAL_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class));
    }

    @Test
    public void testExecuteListAsPostWithPagination() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").queryParams("firstResult", (Object)1, new Object[0]).queryParams("maxResults", (Object)2, new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class), Matchers.eq((int)1), Matchers.eq((int)2));
    }

    @Test
    public void testExecuteListWithExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body((Object)extendingQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.argThat((Matcher)TaskQueryMatcher.hasName("aName")));
    }

    @Test
    public void testExecuteListWithExtendingQueryWithPagination() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").queryParams("firstResult", (Object)1, new Object[0]).queryParams("maxResults", (Object)2, new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body((Object)extendingQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.argThat((Matcher)TaskQueryMatcher.hasName("aName")), Matchers.eq((int)1), Matchers.eq((int)2));
    }

    @Test
    public void testExecuteListWithInvalidExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body(invalidExtendingQuery).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_LIST_FILTER_URL, new Object[0]);
    }

    @Test
    public void testExecuteCount() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().get(EXECUTE_COUNT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).count((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.isNull(Query.class));
    }

    @Test
    public void testExecuteCountOfNonExistingFilter() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(EXECUTE_COUNT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).count("nonExistingId", null);
    }

    @Test
    public void testExecuteCountAsPost() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_COUNT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).count((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class));
    }

    @Test
    public void testExecuteCountWithExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body((Object)extendingQueryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTE_COUNT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock)).count((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.argThat((Matcher)TaskQueryMatcher.hasName("aName")));
    }

    @Test
    public void testExecuteCountWithInvalidExtendingQuery() {
        RestAssured.given().header(ACCEPT_JSON_HEADER).pathParam("id", (Object)"aFilterId").contentType(POST_JSON_CONTENT_TYPE).body(invalidExtendingQuery).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_COUNT_FILTER_URL, new Object[0]);
    }

    @Test
    public void testAnonymousFilterOptions() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)3), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/create")), new Object[0]).body("links[2].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", org.hamcrest.Matchers.equalTo((Object)"create"), new Object[0]).when().options(FILTER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testRestrictedFilterOptions() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL;
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.FILTER, "*")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)2), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).when().options(FILTER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testFilterOptionsWithDisabledAuthorization() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL;
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)3), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/create")), new Object[0]).body("links[2].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", org.hamcrest.Matchers.equalTo((Object)"create"), new Object[0]).when().options(FILTER_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testAnonymousFilterResourceOptions() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL + "/" + "aFilterId";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)9), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[2].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[2].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[3].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[3].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[3].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[4].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[4].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[4].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[5].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[5].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[5].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[6].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[6].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[6].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[7].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[7].method", org.hamcrest.Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[7].rel", org.hamcrest.Matchers.equalTo((Object)"delete"), new Object[0]).body("links[8].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[8].method", org.hamcrest.Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[8].rel", org.hamcrest.Matchers.equalTo((Object)"update"), new Object[0]).when().options(SINGLE_FILTER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)3))).getCurrentAuthentication();
    }

    @Test
    public void testFilterResourceOptionsUnauthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.READ, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)0), new Object[0]).when().options(SINGLE_FILTER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)3))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.READ, (Resource)Resources.FILTER, "aFilterId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.FILTER, "aFilterId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.FILTER, "aFilterId");
    }

    @Test
    public void testFilterResourceOptionsUpdateUnauthorized() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL + "/" + "aFilterId";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.READ, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.FILTER, "aFilterId")).thenReturn((Object)false);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)8), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[2].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[2].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[3].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[3].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[3].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[4].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[4].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[4].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[5].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[5].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[5].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[6].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[6].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[6].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[7].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[7].method", org.hamcrest.Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[7].rel", org.hamcrest.Matchers.equalTo((Object)"delete"), new Object[0]).when().options(SINGLE_FILTER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)3))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.READ, (Resource)Resources.FILTER, "aFilterId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.FILTER, "aFilterId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.FILTER, "aFilterId");
    }

    @Test
    public void testFilterResourceOptionsWithAuthorizationDisabled() {
        String fullFilterUrl = "http://localhost:" + PORT + FILTER_URL + "/" + "aFilterId";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().statusCode(Response.Status.OK.getStatusCode()).body("links.size()", org.hamcrest.Matchers.is((Object)9), new Object[0]).body("links[0].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[0].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", org.hamcrest.Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[1].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[2].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/singleResult")), new Object[0]).body("links[2].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", org.hamcrest.Matchers.equalTo((Object)"singleResult"), new Object[0]).body("links[3].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[3].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[3].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[4].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/list")), new Object[0]).body("links[4].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[4].rel", org.hamcrest.Matchers.equalTo((Object)"list"), new Object[0]).body("links[5].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[5].method", org.hamcrest.Matchers.equalTo((Object)"GET"), new Object[0]).body("links[5].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[6].href", org.hamcrest.Matchers.equalTo((Object)(fullFilterUrl + "/count")), new Object[0]).body("links[6].method", org.hamcrest.Matchers.equalTo((Object)"POST"), new Object[0]).body("links[6].rel", org.hamcrest.Matchers.equalTo((Object)"count"), new Object[0]).body("links[7].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[7].method", org.hamcrest.Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[7].rel", org.hamcrest.Matchers.equalTo((Object)"delete"), new Object[0]).body("links[8].href", org.hamcrest.Matchers.equalTo((Object)fullFilterUrl), new Object[0]).body("links[8].method", org.hamcrest.Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[8].rel", org.hamcrest.Matchers.equalTo((Object)"update"), new Object[0]).when().options(SINGLE_FILTER_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testHalTaskQueryWithWrongFormatVariablesProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("variables", "foo");
        Filter filter = MockProvider.mockFilter().properties(properties).build();
        Mockito.when((Object)this.filterServiceMock.getFilter((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock, (VerificationMode)Mockito.times((int)1))).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).variableScopeIdIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).variableNameIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).list();
    }

    @Test
    public void testHalTaskQueryWithEmptyVariablesProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("variables", Collections.emptyList());
        Filter filter = MockProvider.mockFilter().properties(properties).build();
        Mockito.when((Object)this.filterServiceMock.getFilter((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)filter);
        RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).expect().statusCode(Response.Status.OK.getStatusCode()).body("_embedded", org.hamcrest.Matchers.equalTo(null), new Object[0]).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock, (VerificationMode)Mockito.times((int)1))).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).variableScopeIdIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).variableNameIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).list();
    }

    @Test
    public void testHalTaskQueryWithVariableNotSetOnTask() {
        this.mockFilterWithVariableNames();
        Task task = this.createTaskMock(TASK_A_ID, PROCESS_INSTANCE_A_ID, EXECUTION_A_ID, null, null);
        Mockito.when((Object)this.filterServiceMock.singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn((Object)task);
        List<VariableInstance> variableInstances = Arrays.asList(this.createExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"execution"), EXECUTION_B_ID), this.createExecutionVariableInstanceMock("execution", (TypedValue)Variables.stringValue((String)"bar"), EXECUTION_B_ID), this.createTaskVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"task"), TASK_B_ID), this.createTaskVariableInstanceMock("task", (TypedValue)Variables.stringValue((String)"bar"), TASK_B_ID));
        Mockito.when((Object)this.variableInstanceQueryMock.unlimitedList()).thenReturn(variableInstances);
        RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).expect().statusCode(Response.Status.OK.getStatusCode()).body("_embedded.containsKey('variable')", org.hamcrest.Matchers.is((Object)true), new Object[0]).body("_embedded.variable.size", org.hamcrest.Matchers.equalTo((Object)0), new Object[0]).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock, (VerificationMode)Mockito.times((int)1))).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableScopeIdIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableScopeIdIn(new String[]{TASK_A_ID, EXECUTION_A_ID, PROCESS_INSTANCE_A_ID});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableNameIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableNameIn(new String[]{"foo", "bar"});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).unlimitedList();
    }

    @Test
    public void testHalTaskQueryWithAdditionalVariables() {
        this.mockFilterWithVariableNames();
        Task task = this.createTaskMock(TASK_A_ID, PROCESS_INSTANCE_A_ID, EXECUTION_A_ID, CASE_INSTANCE_A_ID, CASE_EXECUTION_A_ID);
        Mockito.when((Object)this.filterServiceMock.singleResult((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn((Object)task);
        List<VariableInstance> variableInstances = Arrays.asList(this.createProcessInstanceVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"processInstance"), PROCESS_INSTANCE_A_ID), this.createProcessInstanceVariableInstanceMock("processInstance", (TypedValue)Variables.stringValue((String)"bar"), PROCESS_INSTANCE_A_ID), this.createExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"execution"), EXECUTION_A_ID), this.createExecutionVariableInstanceMock("execution", (TypedValue)Variables.stringValue((String)"bar"), EXECUTION_A_ID), this.createTaskVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"task"), TASK_A_ID), this.createTaskVariableInstanceMock("task", (TypedValue)Variables.stringValue((String)"bar"), TASK_A_ID), this.createCaseInstanceVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"caseInstance"), CASE_INSTANCE_A_ID), this.createCaseInstanceVariableInstanceMock("caseInstance", (TypedValue)Variables.stringValue((String)"bar"), CASE_INSTANCE_A_ID), this.createCaseExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)"caseExecution"), CASE_EXECUTION_A_ID), this.createCaseExecutionVariableInstanceMock("caseExecution", (TypedValue)Variables.stringValue((String)"bar"), CASE_EXECUTION_A_ID));
        Mockito.when((Object)this.variableInstanceQueryMock.unlimitedList()).thenReturn(variableInstances);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).expect().statusCode(Response.Status.OK.getStatusCode()).body("_embedded.containsKey('variable')", org.hamcrest.Matchers.is((Object)true), new Object[0]).body("_embedded.variable.size", org.hamcrest.Matchers.equalTo((Object)6), new Object[0]).when().get(EXECUTE_SINGLE_RESULT_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock, (VerificationMode)Mockito.times((int)1))).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableScopeIdIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableScopeIdIn(new String[]{TASK_A_ID, EXECUTION_A_ID, PROCESS_INSTANCE_A_ID, CASE_EXECUTION_A_ID, CASE_INSTANCE_A_ID});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableNameIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableNameIn(new String[]{"foo", "bar"});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).unlimitedList();
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableCustomObjectDeserialization();
        String content = response.asString();
        List variables = (List)JsonPath.from((String)content).getJsonObject("_embedded.variable");
        this.verifyTaskVariableValue((Map)variables.get(0), "foo", "task", TASK_A_ID);
        this.verifyTaskVariableValue((Map)variables.get(1), "task", "bar", TASK_A_ID);
        this.verifyExecutionVariableValue((Map)variables.get(2), "execution", "bar", EXECUTION_A_ID);
        this.verifyProcessInstanceVariableValue((Map)variables.get(3), "processInstance", "bar", PROCESS_INSTANCE_A_ID);
        this.verifyCaseExecutionVariableValue((Map)variables.get(4), "caseExecution", "bar", CASE_EXECUTION_A_ID);
        this.verifyCaseInstanceVariableValue((Map)variables.get(5), "caseInstance", "bar", CASE_INSTANCE_A_ID);
    }

    @Test
    public void testHalTaskListQueryWithAdditionalVariables() {
        this.mockFilterWithVariableNames();
        List<Task> tasks = Arrays.asList(this.createTaskMock(TASK_A_ID, PROCESS_INSTANCE_A_ID, EXECUTION_A_ID, null, null), this.createTaskMock(TASK_B_ID, PROCESS_INSTANCE_A_ID, EXECUTION_B_ID, null, null), this.createTaskMock(TASK_C_ID, null, null, CASE_INSTANCE_A_ID, CASE_EXECUTION_A_ID));
        Mockito.when((Object)this.filterServiceMock.list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn(tasks);
        List<VariableInstance> variableInstances = Arrays.asList(this.createProcessInstanceVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)PROCESS_INSTANCE_A_ID), PROCESS_INSTANCE_A_ID), this.createProcessInstanceVariableInstanceMock(PROCESS_INSTANCE_A_ID, (TypedValue)Variables.stringValue((String)"bar"), PROCESS_INSTANCE_A_ID), this.createExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)EXECUTION_A_ID), EXECUTION_A_ID), this.createExecutionVariableInstanceMock(EXECUTION_A_ID, (TypedValue)Variables.stringValue((String)"bar"), EXECUTION_A_ID), this.createExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)EXECUTION_B_ID), EXECUTION_B_ID), this.createExecutionVariableInstanceMock(EXECUTION_B_ID, (TypedValue)Variables.stringValue((String)"bar"), EXECUTION_B_ID), this.createTaskVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)TASK_A_ID), TASK_A_ID), this.createTaskVariableInstanceMock(TASK_A_ID, (TypedValue)Variables.stringValue((String)"bar"), TASK_A_ID), this.createTaskVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)TASK_B_ID), TASK_B_ID), this.createTaskVariableInstanceMock(TASK_B_ID, (TypedValue)Variables.stringValue((String)"bar"), TASK_B_ID), this.createTaskVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)TASK_C_ID), TASK_C_ID), this.createTaskVariableInstanceMock(TASK_C_ID, (TypedValue)Variables.stringValue((String)"bar"), TASK_C_ID), this.createCaseInstanceVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)CASE_INSTANCE_A_ID), CASE_INSTANCE_A_ID), this.createCaseInstanceVariableInstanceMock(CASE_INSTANCE_A_ID, (TypedValue)Variables.stringValue((String)"bar"), CASE_INSTANCE_A_ID), this.createCaseExecutionVariableInstanceMock("foo", (TypedValue)Variables.stringValue((String)CASE_EXECUTION_A_ID), CASE_EXECUTION_A_ID), this.createCaseExecutionVariableInstanceMock(CASE_EXECUTION_A_ID, (TypedValue)Variables.stringValue((String)"bar"), CASE_EXECUTION_A_ID));
        Mockito.when((Object)this.variableInstanceQueryMock.unlimitedList()).thenReturn(variableInstances);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).expect().statusCode(Response.Status.OK.getStatusCode()).body("_embedded.task.size", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).body("_embedded.task.any { it._embedded.containsKey('variable') }", org.hamcrest.Matchers.is((Object)true), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.filterServiceMock, (VerificationMode)Mockito.times((int)1))).getFilter((String)Matchers.eq((Object)"aFilterId"));
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableScopeIdIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableScopeIdIn(new String[]{TASK_A_ID, EXECUTION_A_ID, PROCESS_INSTANCE_A_ID, TASK_B_ID, EXECUTION_B_ID, TASK_C_ID, CASE_EXECUTION_A_ID, CASE_INSTANCE_A_ID});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).variableNameIn(new String[]{(String)Matchers.anyVararg()});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock)).variableNameIn(new String[]{"foo", "bar"});
        ((VariableInstanceQueryImpl)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).unlimitedList();
        String content = response.asString();
        List taskList = JsonPath.from((String)content).getList("_embedded.task");
        List<Map<String, Object>> variables = this.getEmbeddedTaskVariables((Map)taskList.get(0));
        Assertions.assertThat(variables).hasSize(4);
        this.verifyTaskVariableValue(variables.get(0), "foo", TASK_A_ID, TASK_A_ID);
        this.verifyTaskVariableValue(variables.get(1), TASK_A_ID, "bar", TASK_A_ID);
        this.verifyExecutionVariableValue(variables.get(2), EXECUTION_A_ID, "bar", EXECUTION_A_ID);
        this.verifyProcessInstanceVariableValue(variables.get(3), PROCESS_INSTANCE_A_ID, "bar", PROCESS_INSTANCE_A_ID);
        variables = this.getEmbeddedTaskVariables((Map)taskList.get(1));
        Assertions.assertThat(variables).hasSize(4);
        this.verifyTaskVariableValue(variables.get(0), "foo", TASK_B_ID, TASK_B_ID);
        this.verifyTaskVariableValue(variables.get(1), TASK_B_ID, "bar", TASK_B_ID);
        this.verifyExecutionVariableValue(variables.get(2), EXECUTION_B_ID, "bar", EXECUTION_B_ID);
        this.verifyProcessInstanceVariableValue(variables.get(3), PROCESS_INSTANCE_A_ID, "bar", PROCESS_INSTANCE_A_ID);
        variables = this.getEmbeddedTaskVariables((Map)taskList.get(2));
        Assertions.assertThat(variables).hasSize(4);
        this.verifyTaskVariableValue(variables.get(0), "foo", TASK_C_ID, TASK_C_ID);
        this.verifyTaskVariableValue(variables.get(1), TASK_C_ID, "bar", TASK_C_ID);
        this.verifyCaseExecutionVariableValue(variables.get(2), CASE_EXECUTION_A_ID, "bar", CASE_EXECUTION_A_ID);
        this.verifyCaseInstanceVariableValue(variables.get(3), CASE_INSTANCE_A_ID, "bar", CASE_INSTANCE_A_ID);
    }

    @Test
    public void testHalTaskListCount() {
        List<Task> tasks = Arrays.asList(this.createTaskMock(TASK_A_ID, PROCESS_INSTANCE_A_ID, EXECUTION_A_ID, null, null), this.createTaskMock(TASK_B_ID, PROCESS_INSTANCE_A_ID, EXECUTION_A_ID, null, null), this.createTaskMock(TASK_C_ID, PROCESS_INSTANCE_A_ID, EXECUTION_B_ID, null, null));
        Mockito.when((Object)this.filterServiceMock.list((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn(tasks);
        Mockito.when((Object)this.filterServiceMock.listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class), Matchers.eq((int)0), Matchers.eq((int)2))).thenReturn(tasks.subList(0, 2));
        Mockito.when((Object)this.filterServiceMock.listPage((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class), Matchers.eq((int)5), Matchers.eq((int)2))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.filterServiceMock.count((String)Matchers.eq((Object)"aFilterId"), (Query)Matchers.any(Query.class))).thenReturn((Object)tasks.size());
        RestAssured.given().pathParam("id", (Object)"aFilterId").header(ACCEPT_HAL_HEADER).then().expect().body("_embedded.task.size", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).body("count", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        RestAssured.given().pathParam("id", (Object)"aFilterId").queryParam("firstResult", new Object[]{0}).queryParam("maxResults", new Object[]{2}).header(ACCEPT_HAL_HEADER).then().expect().body("_embedded.task.size", org.hamcrest.Matchers.equalTo((Object)2), new Object[0]).body("count", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
        RestAssured.given().pathParam("id", (Object)"aFilterId").queryParam("firstResult", new Object[]{5}).queryParam("maxResults", new Object[]{2}).header(ACCEPT_HAL_HEADER).then().expect().body("_embedded.containsKey('task')", org.hamcrest.Matchers.is((Object)false), new Object[0]).body("count", org.hamcrest.Matchers.equalTo((Object)3), new Object[0]).when().get(EXECUTE_LIST_FILTER_URL, new Object[0]);
    }

    protected List<Map<String, Object>> getEmbeddedTaskVariables(Map<String, Object> task) {
        Map embedded = (Map)task.get("_embedded");
        Assertions.assertThat((Map)embedded).isNotNull();
        return (List)embedded.get("variable");
    }

    protected Filter mockFilterWithVariableNames() {
        ArrayList variables = new ArrayList();
        HashMap<String, String> foo = new HashMap<String, String>();
        foo.put("name", "foo");
        foo.put("label", "Foo");
        variables.add(foo);
        HashMap<String, String> bar = new HashMap<String, String>();
        bar.put("name", "bar");
        bar.put("label", "Bar");
        variables.add(bar);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("variables", variables);
        Filter filter = MockProvider.mockFilter().properties(properties).build();
        Mockito.when((Object)this.filterServiceMock.getFilter((String)Matchers.eq((Object)"aFilterId"))).thenReturn((Object)filter);
        return filter;
    }

    protected Task createTaskMock(String taskId, String processInstanceId, String executionId, String caseInstanceId, String caseExecutionId) {
        return new MockTaskBuilder().id(taskId).processInstanceId(processInstanceId).executionId(executionId).caseInstanceId(caseInstanceId).caseExecutionId(caseExecutionId).build();
    }

    protected VariableInstance createTaskVariableInstanceMock(String name, TypedValue value, String taskId) {
        return this.createVariableInstanceMock(name, value, taskId, null, null, null, null);
    }

    protected VariableInstance createExecutionVariableInstanceMock(String name, TypedValue value, String executionId) {
        return this.createVariableInstanceMock(name, value, null, executionId, null, null, null);
    }

    protected VariableInstance createProcessInstanceVariableInstanceMock(String name, TypedValue value, String processInstanceId) {
        return this.createVariableInstanceMock(name, value, null, processInstanceId, processInstanceId, null, null);
    }

    protected VariableInstance createCaseExecutionVariableInstanceMock(String name, TypedValue value, String caseExecutionId) {
        return this.createVariableInstanceMock(name, value, null, null, null, caseExecutionId, null);
    }

    protected VariableInstance createCaseInstanceVariableInstanceMock(String name, TypedValue value, String caseInstanceId) {
        return this.createVariableInstanceMock(name, value, null, null, null, caseInstanceId, caseInstanceId);
    }

    protected VariableInstance createVariableInstanceMock(String name, TypedValue value, String taskId, String executionId, String processInstanceId, String caseExecutionId, String caseInstanceId) {
        return MockProvider.mockVariableInstance().name(name).typedValue(value).taskId(taskId).executionId(executionId).processInstanceId(processInstanceId).caseExecutionId(caseExecutionId).caseInstanceId(caseInstanceId).buildEntity();
    }

    protected void verifyTaskVariableValue(Map<String, Object> variable, String name, String value, String taskId) {
        this.verifyVariableValue(variable, name, value, "/task", taskId, "localVariables");
    }

    protected void verifyExecutionVariableValue(Map<String, Object> variable, String name, String value, String executionId) {
        this.verifyVariableValue(variable, name, value, "/execution", executionId, "localVariables");
    }

    protected void verifyCaseExecutionVariableValue(Map<String, Object> variable, String name, String value, String caseExecutionId) {
        this.verifyVariableValue(variable, name, value, "/case-execution", caseExecutionId, "localVariables");
    }

    protected void verifyProcessInstanceVariableValue(Map<String, Object> variable, String name, String value, String processInstanceId) {
        this.verifyVariableValue(variable, name, value, "/process-instance", processInstanceId, "variables");
    }

    protected void verifyCaseInstanceVariableValue(Map<String, Object> variable, String name, String value, String caseInstanceId) {
        this.verifyVariableValue(variable, name, value, "/case-instance", caseInstanceId, "variables");
    }

    protected void verifyVariableValue(Map<String, Object> variable, String name, String value, String scopeResourcePath, String scopeId, String variablesName) {
        Assertions.assertThat((Object)variable.get("name")).isEqualTo((Object)name);
        Assertions.assertThat((Object)variable.get("value")).isEqualTo((Object)value);
        Assertions.assertThat((Object)variable.get("type")).isEqualTo((Object)"String");
        Assertions.assertThat((Object)variable.get("valueInfo")).isEqualTo(Collections.emptyMap());
        Assertions.assertThat((Object)variable.get("_embedded")).isNull();
        Map links = (Map)variable.get("_links");
        Assertions.assertThat((Map)links).hasSize(1);
        Assertions.assertThat((Map)((Map)links.get("self"))).hasSize(1);
        Assertions.assertThat((String)((String)((Map)links.get("self")).get("href"))).isEqualTo((Object)(scopeResourcePath + "/" + scopeId + "/" + variablesName + "/" + name));
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(Matchers.anyString(), Matchers.anyListOf(String.class), (Permission)Matchers.any(Permission.class), (Resource)Matchers.any(Resource.class));
    }
}

