/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util.container;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.camunda.bpm.engine.rest.CustomJacksonDateFormatTest;
import org.camunda.bpm.engine.rest.ExceptionHandlerTest;
import org.camunda.bpm.engine.rest.application.TestCustomResourceApplication;
import org.camunda.bpm.engine.rest.util.container.ContainerSpecifics;
import org.camunda.bpm.engine.rest.util.container.JaxrsApplication;
import org.camunda.bpm.engine.rest.util.container.JerseyServerBootstrap;
import org.camunda.bpm.engine.rest.util.container.JerseyTomcatServerBootstrap;
import org.camunda.bpm.engine.rest.util.container.TestRuleFactory;
import org.camunda.bpm.engine.rest.util.container.TomcatServerBootstrap;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class JerseySpecifics
implements ContainerSpecifics {
    protected static final TestRuleFactory DEFAULT_RULE_FACTORY = new EmbeddedServerRuleFactory(new JaxrsApplication());
    protected static final Map<Class<?>, TestRuleFactory> TEST_RULE_FACTORIES = new HashMap();

    @Override
    public TestRule getTestRule(Class<?> testClass) {
        TestRuleFactory ruleFactory = DEFAULT_RULE_FACTORY;
        if (TEST_RULE_FACTORIES.containsKey(testClass)) {
            ruleFactory = TEST_RULE_FACTORIES.get(testClass);
        }
        return ruleFactory.createTestRule();
    }

    public TestRule getTestRule(String webXmlResource) {
        throw new UnsupportedOperationException();
    }

    static {
        TEST_RULE_FACTORIES.put(ExceptionHandlerTest.class, new EmbeddedServerRuleFactory(new TestCustomResourceApplication()));
        TEST_RULE_FACTORIES.put(CustomJacksonDateFormatTest.class, new ServletContainerRuleFactory("custom-date-format-web.xml"));
    }

    public static class ServletContainerRuleFactory
    implements TestRuleFactory {
        protected String webXmlResource;

        public ServletContainerRuleFactory(String webXmlResource) {
            this.webXmlResource = webXmlResource;
        }

        @Override
        public TestRule createTestRule() {
            final TemporaryFolder tempFolder = new TemporaryFolder();
            return RuleChain.outerRule((TestRule)tempFolder).around((TestRule)new ExternalResource(){
                TomcatServerBootstrap bootstrap;
                {
                    this.bootstrap = new JerseyTomcatServerBootstrap(webXmlResource);
                }

                protected void before() throws Throwable {
                    this.bootstrap.setWorkingDir(tempFolder.getRoot().getAbsolutePath());
                    this.bootstrap.start();
                }

                protected void after() {
                    this.bootstrap.stop();
                }
            });
        }
    }

    public static class EmbeddedServerRuleFactory
    implements TestRuleFactory {
        protected Application jaxRsApplication;

        public EmbeddedServerRuleFactory(Application jaxRsApplication) {
            this.jaxRsApplication = jaxRsApplication;
        }

        @Override
        public TestRule createTestRule() {
            return new ExternalResource(){
                JerseyServerBootstrap bootstrap;
                {
                    this.bootstrap = new JerseyServerBootstrap(jaxRsApplication);
                }

                protected void before() throws Throwable {
                    this.bootstrap.start();
                }

                protected void after() {
                    this.bootstrap.stop();
                }
            };
        }
    }
}

