/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class TelemetryRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TELEMETRY_URL = "/rest-test/telemetry";
    protected static final String TELEMETRY_CONFIG_URL = "/rest-test/telemetry/configuration";
    protected ManagementService managementServiceMock;

    @Before
    public void setupMocks() {
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
    }

    @Test
    public void shouldDisableTelemetry() {
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", false);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).toggleTelemetry(false);
    }

    @Test
    public void shouldEnableTelemetry() {
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).toggleTelemetry(true);
    }

    @Test
    public void shouldThrowAuthorizationExceptionOnEnablingTelemetry() {
        String message = "Required admin authenticated group or user.";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.managementServiceMock)).toggleTelemetry(Mockito.anyBoolean());
        HashMap<String, Boolean> requestBody = new HashMap<String, Boolean>();
        requestBody.put("enableTelemetry", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(requestBody).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TELEMETRY_CONFIG_URL, new Object[0]);
    }

    @Test
    public void shouldFetchEnabledTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn((Object)true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo((Object)true), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldFetchDisabledTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn((Object)false);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo((Object)false), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldFetchEmptyTelemetryConfiguration() {
        Mockito.when((Object)this.managementServiceMock.isTelemetryEnabled()).thenReturn(null);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("enableTelemetry", Matchers.equalTo(null), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }

    @Test
    public void shouldThrowAuthorizationExceptionOnFetchingTelemetryConfig() {
        String message = "Required admin authenticated group or user.";
        ((ManagementService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.managementServiceMock)).isTelemetryEnabled();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(TELEMETRY_CONFIG_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).isTelemetryEnabled();
    }
}

