/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DateConverterTest {
    private DateConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new DateConverter();
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldFailForDoubleQuotedValue() {
        this.converter.convertQueryParameterToType("\"pizza\"");
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldFailForSingleDoubleQuotedValue() {
        this.converter.convertQueryParameterToType("2014-01-01T00:00:00+0200\"");
    }

    @Test
    public void shouldConvertDate() throws JsonProcessingException {
        String value = "2014-01-01T00:00:00+0200";
        ObjectMapper mock = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        this.converter.setObjectMapper(mock);
        Mockito.when((Object)mock.readValue(Matchers.anyString(), (Class)Mockito.eq(Date.class))).thenReturn((Object)DateTimeUtil.parseDate((String)value));
        Date date = this.converter.convertQueryParameterToType(value);
        Assert.assertEquals((Object)date, (Object)DateTimeUtil.parseDate((String)value));
    }
}

