/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.optimize;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class OptimizeRunningActivityInstanceRestServiceTest
extends AbstractRestServiceTest {
    public static final String OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH = "/rest-test/optimize/activity-instance/running";
    protected OptimizeService mockedOptimizeService;
    protected ProcessEngine namedProcessEngine;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.mockedOptimizeService = (OptimizeService)Mockito.mock(OptimizeService.class);
        ProcessEngineConfigurationImpl mockedConfig = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getProcessEngineConfiguration()).thenReturn((Object)mockedConfig);
        Mockito.when((Object)mockedConfig.getOptimizeService()).thenReturn((Object)this.mockedOptimizeService);
    }

    @Test
    public void testNoQueryParameters() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getRunningHistoricActivityInstances(null, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testStartedAfterQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("startedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getRunningHistoricActivityInstances(now, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testStartedAtQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("startedAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getRunningHistoricActivityInstances(null, now, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testMaxResultsQueryParameter() {
        RestAssured.given().queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getRunningHistoricActivityInstances(null, null, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testQueryParameterCombination() {
        Date now = new Date();
        RestAssured.given().queryParam("startedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("startedAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getRunningHistoricActivityInstances(now, now, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testPresenceOfSequenceCounterProperty() {
        HistoricActivityInstanceEntity mock = (HistoricActivityInstanceEntity)Mockito.mock(HistoricActivityInstanceEntity.class);
        Mockito.when((Object)mock.getSequenceCounter()).thenReturn((Object)10L);
        Mockito.when((Object)this.mockedOptimizeService.getRunningHistoricActivityInstances(null, null, Integer.MAX_VALUE)).thenReturn(Collections.singletonList(mock));
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_RUNNING_ACTIVITY_INSTANCE_PATH, new Object[0]);
        String content = response.asString();
        long sequenceCounter = JsonPath.from((String)content).getLong("[0].sequenceCounter");
        Assert.assertEquals((long)10L, (long)sequenceCounter);
    }
}

