/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.StringToTypeConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;

public abstract class AbstractQueryDto<T extends Query<?, ?>> {
    protected static final String SORT_ORDER_ASC_VALUE = "asc";
    protected static final String SORT_ORDER_DESC_VALUE = "desc";
    private static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList();
    protected String sortBy;
    protected String sortOrder;

    public AbstractQueryDto() {
    }

    public AbstractQueryDto(MultivaluedMap<String, String> queryParameters) {
        for (Map.Entry param : queryParameters.entrySet()) {
            String key = (String)param.getKey();
            String value = (String)((List)param.getValue()).iterator().next();
            this.setValueBasedOnAnnotation(key, value);
        }
    }

    @CamundaQueryParam(value="sortBy")
    public void setSortBy(String sortBy) {
        if (!this.isValidSortByValue(sortBy)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortBy);
        }
        this.sortBy = sortBy;
    }

    @CamundaQueryParam(value="sortOrder")
    public void setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortOrder parameter has invalid value: " + sortOrder);
        }
        this.sortOrder = sortOrder;
    }

    protected abstract boolean isValidSortByValue(String var1);

    protected boolean sortOptionsValid() {
        return this.sortBy != null && this.sortOrder != null || this.sortBy == null && this.sortOrder == null;
    }

    protected void setValueBasedOnAnnotation(String key, String value) {
        List matchingMethods = this.findMatchingAnnotatedMethods(key);
        for (Method method : matchingMethods) {
            Class converterClass = this.findAnnotatedTypeConverter(method);
            if (converterClass == null) continue;
            StringToTypeConverter converter = null;
            try {
                converter = (StringToTypeConverter)converterClass.newInstance();
                Object convertedValue = converter.convertQueryParameterToType(value);
                method.invoke((Object)this, convertedValue);
            }
            catch (InstantiationException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e, "Server error.");
            }
            catch (IllegalAccessException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e, "Server error.");
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, "Cannot set query parameter '" + key + "' to value '" + value + "'");
            }
            catch (InvocationTargetException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, "Cannot set query parameter '" + key + "' to value '" + value + "'");
            }
        }
    }

    private List<Method> findMatchingAnnotatedMethods(String parameterName) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Annotation[] methodAnnotations = method.getAnnotations();
            for (int j = 0; j < methodAnnotations.length; ++j) {
                CamundaQueryParam parameterAnnotation;
                Annotation annotation = methodAnnotations[j];
                if (!(annotation instanceof CamundaQueryParam) || !(parameterAnnotation = (CamundaQueryParam)annotation).value().equals(parameterName)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private Class<? extends StringToTypeConverter<?>> findAnnotatedTypeConverter(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        for (int j = 0; j < methodAnnotations.length; ++j) {
            Annotation annotation = methodAnnotations[j];
            if (!(annotation instanceof CamundaQueryParam)) continue;
            CamundaQueryParam parameterAnnotation = (CamundaQueryParam)annotation;
            return parameterAnnotation.converter();
        }
        return null;
    }

    public T toQuery(ProcessEngine engine) {
        Query query = this.createNewQuery(engine);
        this.applyFilters(query);
        if (!this.sortOptionsValid()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single sorting parameter specified. sortBy and sortOrder required");
        }
        this.applySortingOptions(query);
        return (T)query;
    }

    protected abstract T createNewQuery(ProcessEngine var1);

    protected abstract void applyFilters(T var1);

    protected abstract void applySortingOptions(T var1);

    static {
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_ASC_VALUE);
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_DESC_VALUE);
    }
}

